# How to Fix the Broken Pipe Error

The broken pipe error happens when the PHP built-in server connection is interrupted. Follow these steps:

## Step 1: Stop the Current Server
1. Find the process: `lsof -i :8000` or check your terminal where you ran `php artisan serve`
2. Kill it: Press `Ctrl+C` in that terminal, or run: `pkill -f "php artisan serve"`

## Step 2: Clear All Caches
Run these commands in your terminal:
```bash
cd tuition-management
php artisan optimize:clear
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear
```

## Step 3: Restart the Server
```bash
php artisan serve
```

## Alternative: Use a Different Port
If the error persists, try using a different port:
```bash
php artisan serve --port=8080
```

Then access: http://127.0.0.1:8080/login

## If Issues Persist
The broken pipe error might be a symptom. Check the actual error in:
```bash
tail -50 storage/logs/laravel.log
```


