<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\FeesGroup;

class FeesGroupController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        if (!$user || !$user->isAdmin()) {
            abort(403, 'Unauthorized access');
        }

        $groups = FeesGroup::orderBy('name')->get();
        return view('admin.fees.group.index', compact('groups', 'user'));
    }

    public function create()
    {
        $user = Auth::user();
        if (!$user || !$user->isAdmin()) {
            abort(403, 'Unauthorized access');
        }
        $types = \App\Models\FeesType::where('is_active', true)->orderBy('name')->get();
        return view('admin.fees.group.create', compact('user', 'types'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'fees_type_id' => 'nullable|exists:fees_types,id',
            'description' => 'nullable|string',
            'is_active' => 'nullable|boolean',
        ]);
        $validated['is_active'] = $request->boolean('is_active', true);

        FeesGroup::create($validated);

        return redirect()->route('admin.fees-group.index')->with('success', 'Fees Group created successfully.');
    }

    public function edit(string $id)
    {
        $user = Auth::user();
        if (!$user || !$user->isAdmin()) {
            abort(403, 'Unauthorized access');
        }
        $group = FeesGroup::findOrFail($id);
        $types = \App\Models\FeesType::where('is_active', true)->orderBy('name')->get();
        return view('admin.fees.group.edit', compact('group', 'user', 'types'));
    }

    public function update(Request $request, string $id)
    {
        $group = FeesGroup::findOrFail($id);
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'fees_type_id' => 'nullable|exists:fees_types,id',
            'description' => 'nullable|string',
            'is_active' => 'nullable|boolean',
        ]);
        $validated['is_active'] = $request->boolean('is_active', true);

        $group->update($validated);

        return redirect()->route('admin.fees-group.index')->with('success', 'Fees Group updated successfully.');
    }

    public function destroy(string $id)
    {
        $group = FeesGroup::findOrFail($id);
        $group->delete();

        return redirect()->route('admin.fees-group.index')->with('success', 'Fees Group deleted successfully.');
    }
}

