<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class ApiAuth
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $token = $request->bearerToken();
        
        if (!$token) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized. Token missing.'
            ], 401);
        }

        // Find user by token (stored in remember_token)
        $user = \App\Models\User::where('remember_token', hash('sha256', $token))->first();
        
        if (!$user) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized. Invalid token.'
            ], 401);
        }

        // Set authenticated user
        Auth::login($user);
        
        return $next($request);
    }
}
