<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeesAssignment extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'fees_type_id',
        'amount',
        'frequency',
        'start_date',
        'end_date',
        'is_active',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'is_active' => 'boolean',
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function feesType()
    {
        return $this->belongsTo(FeesType::class);
    }
}



