<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Student extends Model
{
    use HasFactory;

    protected $fillable = [
        'admission_no',
        'name',
        'email',
        'phone',
        'date_of_birth',
        'gender',
        'category',
        'roll_number',
        'photo',
        'academic_year_id',
        'class_id',
        'section_id',
        'batch_id',
        'parent_id',
        'father_name',
        'father_phone',
        'father_occupation',
        'father_photo',
        'mother_name',
        'mother_phone',
        'mother_occupation',
        'mother_photo',
        'guardian_name',
        'guardian_phone',
        'guardian_relation',
        'guardian_email',
        'guardian_occupation',
        'guardian_address',
        'guardian_photo',
        'address',
        'current_address',
        'permanent_address',
        'city',
        'state',
        'zip_code',
        'country',
        'blood_group',
        'height',
        'weight',
        'bank_account_number',
        'bank_name',
        'ifsc_code',
        'national_identification_number',
        'previous_school_name',
        'previous_school_address',
        'hostel',
        'room_no',
        'student_details',
        'student_login_email',
        'is_active',
    ];

    protected $casts = [
        'date_of_birth' => 'date',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class, 'academic_year_id');
    }

    public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id');
    }

    public function batch()
    {
        return $this->belongsTo(Batch::class, 'batch_id');
    }

    public function parent()
    {
        return $this->belongsTo(User::class, 'parent_id');
    }
}
