<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use App\Models\Subject;

class Teacher extends Model
{
    use HasFactory;

    protected $fillable = [
        'teacher_id',
        'name',
        'email',
        'phone',
        'date_of_birth',
        'gender',
        'subject',
        'father_name',
        'mother_name',
        'marital_status',
        'contract_type',
        'shift',
        'work_location',
        'join_date',
        'experience',
        'qualification',
        'photo',
        'blood_group',
        'height',
        'weight',
        'bank_account_number',
        'bank_name',
        'ifsc_code',
        'national_identification_number',
        'previous_school_name',
        'previous_school_address',
        'user_id',
        'is_active',
    ];

    protected $casts = [
        'date_of_birth' => 'date',
        'join_date' => 'date',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function schoolClass(): BelongsTo
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }

    public function documents(): HasMany
    {
        return $this->hasMany(TeacherDocument::class, 'teacher_id');
    }

    public function subjects(): BelongsToMany
    {
        return $this->belongsToMany(Subject::class, 'subject_teacher');
    }

    /**
     * Check if teacher has any documents uploaded
     */
    public function hasDocuments(): bool
    {
        return $this->documents()->count() > 0;
    }

    /**
     * Get verification status
     * Returns 'verified' if documents exist, 'not_verified' otherwise
     */
    public function getVerificationStatusAttribute(): string
    {
        return $this->hasDocuments() ? 'verified' : 'not_verified';
    }

    /**
     * Check if teacher is verified
     */
    public function isVerified(): bool
    {
        return $this->hasDocuments();
    }
}
