<?php

namespace App\Services\PaymentGateway;

use App\Models\FeesCollection;

class CashfreeGateway implements PaymentGatewayInterface
{
    public function __construct(
        protected ?string $appId,
        protected ?string $secretKey,
        protected string $mode = 'sandbox',
    ) {}

    public function createOrder(FeesCollection $collection): array
    {
        // TODO: Implement Cashfree API integration here.
        // For now we just return a placeholder structure.
        return [
            'gateway' => 'cashfree',
            'amount' => $collection->amount,
            'currency' => 'INR',
            'order_id' => 'CF-DEMO-' . $collection->id,
            'redirect_url' => route('parent.fees'),
        ];
    }

    public function handleCallback(array $payload): void
    {
        // TODO: Verify signature and update FeesCollection/payment status.
    }
}


