<?php

namespace App\Services\PaymentGateway;

use App\Models\Setting;

class PaymentGatewayManager
{
    public function getActiveGateway(): ?PaymentGatewayInterface
    {
        $setting = Setting::first();
        if (!$setting) {
            return null;
        }

        // Priority order: Cashfree -> Razorpay -> PhonePe
        if ($setting->cashfree_active) {
            return new CashfreeGateway(
                $setting->cashfree_app_id,
                $setting->cashfree_secret_key,
                $setting->cashfree_mode ?? 'sandbox',
            );
        }

        if ($setting->razorpay_active) {
            return new RazorpayGateway(
                $setting->razorpay_key_id,
                $setting->razorpay_key_secret,
            );
        }

        if ($setting->phonepe_active) {
            return new PhonePeGateway(
                $setting->phonepe_merchant_id,
                $setting->phonepe_salt_key,
                $setting->phonepe_salt_index,
                $setting->phonepe_mode ?? 'sandbox',
            );
        }

        return null;
    }
}


