<?php

namespace App\Services\PaymentGateway;

use App\Models\FeesCollection;

class PhonePeGateway implements PaymentGatewayInterface
{
    public function __construct(
        protected ?string $merchantId,
        protected ?string $saltKey,
        protected ?string $saltIndex,
        protected string $mode = 'sandbox',
    ) {}

    public function createOrder(FeesCollection $collection): array
    {
        // TODO: Implement PhonePe payment request here.
        return [
            'gateway' => 'phonepe',
            'amount' => $collection->amount,
            'currency' => 'INR',
            'order_id' => 'PP-DEMO-' . $collection->id,
            'redirect_url' => route('parent.fees'),
        ];
    }

    public function handleCallback(array $payload): void
    {
        // TODO: Verify signature and update FeesCollection/payment status.
    }
}


