<?php

namespace App\Services\PaymentGateway;

use App\Models\FeesCollection;

class RazorpayGateway implements PaymentGatewayInterface
{
    public function __construct(
        protected ?string $keyId,
        protected ?string $keySecret,
    ) {}

    public function createOrder(FeesCollection $collection): array
    {
        // TODO: Implement Razorpay order creation here.
        return [
            'gateway' => 'razorpay',
            'amount' => $collection->amount,
            'currency' => 'INR',
            'order_id' => 'RZP-DEMO-' . $collection->id,
            'redirect_url' => route('parent.fees'),
        ];
    }

    public function handleCallback(array $payload): void
    {
        // TODO: Verify signature and update FeesCollection/payment status.
    }
}


