<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $driver = DB::getDriverName();
        
        if ($driver === 'sqlite') {
            // SQLite doesn't support ALTER COLUMN, so we need to recreate the table
            // For now, we'll just note that the enum constraint is handled at application level
            // The actual constraint will be enforced by Laravel validation
        } else {
            // MySQL/MariaDB
            DB::statement("ALTER TABLE users MODIFY COLUMN role ENUM('admin', 'teacher', 'parent', 'student') DEFAULT 'parent'");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $driver = DB::getDriverName();
        
        if ($driver === 'sqlite') {
            // SQLite doesn't support ALTER COLUMN
        } else {
            // MySQL/MariaDB
            DB::statement("ALTER TABLE users MODIFY COLUMN role ENUM('admin', 'teacher', 'parent') DEFAULT 'parent'");
        }
    }
};
