<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('teachers', function (Blueprint $table) {
            $table->id();
            $table->string('teacher_id')->unique(); // Auto-generated teacher ID
            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->enum('gender', ['Male', 'Female', 'Other'])->nullable();
            $table->string('subject')->nullable();
            $table->foreignId('class_id')->nullable()->constrained('school_classes')->onDelete('set null');
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->enum('marital_status', ['Married', 'Unmarried'])->nullable();
            $table->enum('contract_type', ['Contractual', 'Hourly'])->nullable();
            $table->enum('shift', ['Day Shift', 'Night Shift'])->nullable();
            $table->string('work_location')->nullable();
            $table->date('join_date')->nullable();
            $table->string('experience')->nullable();
            $table->string('qualification')->nullable();
            $table->string('photo')->nullable();
            
            // Medical Details
            $table->string('blood_group')->nullable();
            $table->string('height')->nullable();
            $table->string('weight')->nullable();
            
            // Bank Details
            $table->string('bank_account_number')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('ifsc_code')->nullable();
            $table->string('national_identification_number')->nullable();
            
            // Previous School Details
            $table->string('previous_school_name')->nullable();
            $table->string('previous_school_address')->nullable();
            
            // Link to User account
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null');
            
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('teachers');
    }
};
