<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->boolean('cashfree_active')->default(false);
            $table->string('cashfree_app_id')->nullable();
            $table->string('cashfree_secret_key')->nullable();
            $table->string('cashfree_mode')->nullable();

            $table->boolean('razorpay_active')->default(false);
            $table->string('razorpay_key_id')->nullable();
            $table->string('razorpay_key_secret')->nullable();

            $table->boolean('phonepe_active')->default(false);
            $table->string('phonepe_merchant_id')->nullable();
            $table->string('phonepe_salt_key')->nullable();
            $table->string('phonepe_salt_index')->nullable();
            $table->string('phonepe_mode')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn([
                'cashfree_active',
                'cashfree_app_id',
                'cashfree_secret_key',
                'cashfree_mode',
                'razorpay_active',
                'razorpay_key_id',
                'razorpay_key_secret',
                'phonepe_active',
                'phonepe_merchant_id',
                'phonepe_salt_key',
                'phonepe_salt_index',
                'phonepe_mode',
            ]);
        });
    }
};

