<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fees_types', function (Blueprint $table) {
            $table->boolean('is_recurring')->default(false);
            $table->enum('recurring_frequency', ['monthly', 'quarterly', 'yearly', 'one_time'])->default('one_time');
            $table->integer('recurring_day')->nullable(); // Day of month (1-28)
            $table->date('recurring_start_date')->nullable();
            $table->date('recurring_end_date')->nullable();
            $table->date('last_generated_date')->nullable();
            $table->boolean('auto_generate')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fees_types', function (Blueprint $table) {
            $table->dropColumn([
                'is_recurring',
                'recurring_frequency',
                'recurring_day',
                'recurring_start_date',
                'recurring_end_date',
                'last_generated_date',
                'auto_generate',
            ]);
        });
    }
};
