<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admin_notifications', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // leave_request, fee_payment, homework_submission, etc.
            $table->string('title');
            $table->text('message');
            $table->string('icon')->nullable();
            $table->string('icon_bg')->nullable();
            $table->string('link')->nullable();
            $table->foreignId('from_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('from_role')->nullable(); // parent, teacher, student
            $table->json('data')->nullable(); // Additional data like student_id, leave_request_id, etc.
            $table->timestamp('read_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admin_notifications');
    }
};
