// Sidebar toggle fix - Vanilla JS fallback
(function() {
  function initSidebarToggle() {
    // Desktop sidebar toggle
    const sidebarToggle = document.querySelector('.sidebar-toggle');
    if (sidebarToggle) {
      sidebarToggle.addEventListener('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        console.log('Sidebar toggle clicked (vanilla JS)'); // Debug
        
        const sidebar = document.querySelector('.sidebar');
        const dashboardMain = document.querySelector('.dashboard-main');
        
        if (sidebar) {
          sidebar.classList.toggle('active');
        }
        if (dashboardMain) {
          dashboardMain.classList.toggle('active');
        }
        this.classList.toggle('active');
        
        return false;
      });
    }
    
    // Mobile sidebar toggle
    const sidebarMobileToggle = document.querySelector('.sidebar-mobile-toggle');
    if (sidebarMobileToggle) {
      sidebarMobileToggle.addEventListener('click', function(e) {
        e.preventDefault();
        const sidebar = document.querySelector('.sidebar');
        if (sidebar) {
          sidebar.classList.add('sidebar-open');
        }
        document.body.classList.add('overlay-active');
      });
    }
    
    // Sidebar close button
    const sidebarCloseBtn = document.querySelector('.sidebar-close-btn');
    if (sidebarCloseBtn) {
      sidebarCloseBtn.addEventListener('click', function(e) {
        e.preventDefault();
        const sidebar = document.querySelector('.sidebar');
        if (sidebar) {
          sidebar.classList.remove('sidebar-open');
        }
        document.body.classList.remove('overlay-active');
      });
    }
  }
  
  // Try both DOMContentLoaded and window load
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initSidebarToggle);
  } else {
    initSidebarToggle();
  }
  
  // Also try on window load as fallback
  window.addEventListener('load', initSidebarToggle);
})();
