@extends('layouts.admin')

@section('title', 'Student Attendance')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Student Attendance</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Attendance</span>
        </div>
    </div>
</div>

<div class="card h-100">
    <div class="card-body p-0 dataTable-wrapper">
        <div class="d-flex align-items-center justify-content-between flex-wrap gap-16 px-20 py-12 border-bottom border-neutral-200">
            <form class="d-flex flex-wrap align-items-end gap-16" method="GET" action="{{ route('admin.attendance.index') }}">
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Date</label>
                    <input type="date" name="date" class="form-control" value="{{ $date }}">
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Class</label>
                    <select name="class_id" class="form-control form-select">
                        <option value="">All</option>
                        @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ $classId == $class->id ? 'selected' : '' }}>{{ $class->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Section</label>
                    <select name="section_id" class="form-control form-select">
                        <option value="">All</option>
                        @foreach($sections as $section)
                        <option value="{{ $section->id }}" {{ $sectionId == $section->id ? 'selected' : '' }}>{{ $section->name }}</option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="btn btn-primary-600">
                    Filter
                </button>
            </form>
        </div>

        <div class="p-0">
            <table class="table bordered-table mb-0 data-table" id="dataTable" data-page-length='40'>
                <thead>
                    <tr>
                        <th>S.L</th>
                        <th>Student</th>
                        <th>Admission No</th>
                        <th>Class</th>
                        <th>Section</th>
                        <th>Status</th>
                        <th>Teacher</th>
                        <th>Remark</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($records as $index => $rec)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $rec->student->name ?? '-' }}</td>
                        <td>{{ $rec->student->admission_no ?? '-' }}</td>
                        <td>{{ $rec->student->schoolClass->name ?? $rec->schoolClass->name ?? '-' }}</td>
                        <td>{{ $rec->student->section->name ?? $rec->section->name ?? '-' }}</td>
                        <td>
                            @if($rec->status === 'present')
                                <span class="badge bg-success">Present</span>
                            @elseif($rec->status === 'absent')
                                <span class="badge bg-danger">Absent</span>
                            @elseif($rec->status === 'late')
                                <span class="badge bg-warning text-dark">Late</span>
                            @else
                                <span class="badge bg-info text-dark">Leave</span>
                            @endif
                        </td>
                        <td>{{ $rec->teacher->name ?? '-' }}</td>
                        <td>{{ $rec->remark }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">No attendance records found for selected filters.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection



