@extends('layouts.admin')

@section('title', 'Dashboard')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h6 class="fw-semibold mb-0">Dashboard</h6>
        <p class="text-neutral-600 mt-4 mb-0">Manage your institution, track fees, attendance, and performance.</p>
    </div>
</div>

<div class="mt-24">
    <div class="row gy-4">
        <!-- Main Content Area -->
        <div class="col-xxl-8">
            <!-- Fee Details Section - First Row -->
            <div class="row gy-4">
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 gradient-bg-end-1 h-100">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-warning-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-money-rupee-circle-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Fees Today</p>
                            </div>
                            <h6 class="mb-0">₹{{ number_format($feesToday, 0) }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                <span class="text-secondary-light text-sm">Collected today</span>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 gradient-bg-end-2 h-100">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-blue-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-calendar-check-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Fees This Month</p>
                            </div>
                            <h6 class="mb-0">₹{{ number_format($feesThisMonth, 0) }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                @if($feeGrowth >= 0)
                                    <span class="d-inline-flex align-items-center gap-1 text-success-600 text-sm fw-semibold">
                                        {{ $feeGrowth }}%
                                        <i class="ri-arrow-up-s-fill text-xs"></i>
                                    </span>
                                @else
                                    <span class="d-inline-flex align-items-center gap-1 text-danger-600 text-sm fw-semibold">
                                        {{ abs($feeGrowth) }}%
                                        <i class="ri-arrow-down-s-fill text-xs"></i>
                                    </span>
                                @endif
                                vs last month
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 gradient-bg-end-3 h-100">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-purple-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-wallet-3-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Total Collected</p>
                            </div>
                            <h6 class="mb-0">₹{{ number_format($totalFeesCollected, 0) }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                <span class="text-secondary-light text-sm">All time collection</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Student/Staff Details Section - Second Row -->
            <div class="row gy-4 mt-0">
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 gradient-bg-end-4 h-100">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-primary-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-graduation-cap-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Total Students</p>
                            </div>
                            <h6 class="mb-0">{{ number_format($totalStudents) }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                @if($newStudentsThisMonth > 0)
                                    <span class="d-inline-flex align-items-center gap-1 text-success-600 text-sm fw-semibold">
                                        +{{ $newStudentsThisMonth }}
                                        <i class="ri-arrow-up-s-fill text-xs"></i>
                                    </span>
                                    This Month
                                @else
                                    <span class="text-secondary-light text-sm">Enrolled students</span>
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 gradient-bg-end-5 h-100">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-success-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-user-star-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Total Teachers</p>
                            </div>
                            <h6 class="mb-0">{{ number_format($totalTeachers) }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                <span class="text-secondary-light text-sm">Active staff</span>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 gradient-bg-end-6 h-100">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-cyan-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-parent-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Total Parents</p>
                            </div>
                            <h6 class="mb-0">{{ number_format($totalParents) }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                <span class="text-secondary-light text-sm">Registered parents</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Third Row - Pending Fees & Classes & Leaves -->
            <div class="row gy-4 mt-0">
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 h-100" style="background: linear-gradient(135deg, #fff5f5 0%, #ffffff 100%);">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-danger-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-error-warning-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Pending Fees</p>
                            </div>
                            <h6 class="mb-0 text-danger-600">₹{{ number_format($pendingFees, 0) }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                <span class="text-secondary-light text-sm">Outstanding balance</span>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 h-100" style="background: linear-gradient(135deg, #f0fdf4 0%, #ffffff 100%);">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-info-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-building-2-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Total Classes</p>
                            </div>
                            <h6 class="mb-0">{{ number_format($totalClasses) }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                <span class="text-secondary-light text-sm">Active classes</span>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-sm-6">
                    <div class="card shadow-1 radius-8 h-100" style="background: linear-gradient(135deg, #fffbeb 0%, #ffffff 100%);">
                        <div class="card-body p-20">
                            <div class="d-flex flex-wrap align-items-center gap-3 mb-16">
                                <div class="w-44-px h-44-px bg-warning-600 rounded-circle d-flex justify-content-center align-items-center">
                                    <i class="ri-file-list-3-line text-white text-xl"></i>
                                </div>
                                <p class="fw-medium text-primary-light mb-1">Pending Leaves</p>
                            </div>
                            <h6 class="mb-0 text-warning-600">{{ $pendingLeaves }}</h6>
                            <p class="fw-medium text-sm text-primary-light mt-12 mb-0 d-flex align-items-center gap-2">
                                <a href="{{ route('admin.leave-requests.index') }}" class="text-primary-600 text-sm">Awaiting approval →</a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Sidebar -->
        <div class="col-xxl-4">
            <div class="d-flex flex-column gap-4">
                <!-- Top Students Section with Slides -->
                <div class="card">
                    <div class="card-body p-0">
                        <div class="d-flex flex-wrap align-items-center justify-content-between px-20 py-16 border-bottom border-neutral-200">
                            <div class="d-flex align-items-center gap-2">
                                <i class="ri-trophy-line text-warning-600"></i>
                                <h6 class="text-lg mb-0">Top Students</h6>
                            </div>
                            @if($lastExam)
                                <span class="badge bg-primary-100 text-primary-600 text-xs">{{ $lastExam->examType->name ?? 'Last Exam' }}</span>
                            @endif
                        </div>
                        @if($topStudents->count())
                            @php
                                $studentChunks = $topStudents->chunk(3);
                            @endphp
                            <div id="topStudentsCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="4000">
                                <div class="carousel-inner">
                                    @foreach($studentChunks as $chunkIndex => $chunk)
                                        <div class="carousel-item {{ $chunkIndex === 0 ? 'active' : '' }}">
                                            <div class="p-20">
                                                <ul class="list-unstyled mb-0">
                                                    @foreach($chunk as $itemIndex => $item)
                                                        @php
                                                            $globalIndex = $chunkIndex * 3 + $itemIndex;
                                                            $student = $item['student'];
                                                            $photo = $student && $student->photo ? asset('storage/'.$student->photo) : asset('assets/images/thumbs/leave-request-img2.png');
                                                            $rankColors = ['#FFD700', '#C0C0C0', '#CD7F32', '#4A90D9', '#6C757D', '#8B5CF6', '#EC4899', '#14B8A6', '#F97316', '#84CC16'];
                                                            $rankColor = $rankColors[$globalIndex] ?? '#6C757D';
                                                        @endphp
                                                        <li class="mb-12 pb-12 {{ !$loop->last ? 'border-bottom' : '' }}">
                                                            <div class="d-flex align-items-center gap-12">
                                                                <div class="position-relative">
                                                                    <img src="{{ $photo }}" alt="{{ $student->name ?? 'Student' }}" class="rounded-circle object-fit-cover" style="width:44px;height:44px;border: 2px solid {{ $rankColor }};">
                                                                    <span class="position-absolute d-flex justify-content-center align-items-center text-white text-xs fw-bold" style="width:20px;height:20px;border-radius:50%;background:{{ $rankColor }};top:-4px;right:-4px;">{{ $globalIndex + 1 }}</span>
                                                                </div>
                                                                <div class="flex-grow-1">
                                                                    <h6 class="fw-semibold text-primary-light mb-0 text-sm">{{ $student->name ?? 'Student' }}</h6>
                                                                    <p class="mb-0 text-secondary-light text-xs">{{ $student->schoolClass->name ?? '' }} • {{ $item['subject'] }}</p>
                                                                </div>
                                                                <div class="text-end">
                                                                    <span class="fw-bold text-primary-600">{{ $item['marks'] }}/{{ $item['total'] }}</span>
                                                                    <p class="mb-0 text-xs {{ $item['percentage'] >= 80 ? 'text-success-600' : ($item['percentage'] >= 60 ? 'text-warning-600' : 'text-danger-600') }}">{{ $item['percentage'] }}%</p>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                @if($studentChunks->count() > 1)
                                    <div class="carousel-indicators position-relative mt-0 mb-12" style="justify-content: center;">
                                        @foreach($studentChunks as $chunkIndex => $chunk)
                                            <button type="button" data-bs-target="#topStudentsCarousel" data-bs-slide-to="{{ $chunkIndex }}" class="{{ $chunkIndex === 0 ? 'active' : '' }}" style="width: 8px; height: 8px; border-radius: 50%; background-color: #ccc; border: none; margin: 0 4px;"></button>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        @else
                            <div class="p-20 text-center">
                                <i class="ri-trophy-line text-4xl text-neutral-300"></i>
                                <p class="mb-0 text-secondary-light mt-8">No exam results available.</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Latest Notes Section with Slides -->
                <div class="card">
                    <div class="card-body p-0">
                        <div class="d-flex flex-wrap align-items-center justify-content-between px-20 py-16 border-bottom border-neutral-200">
                            <div class="d-flex align-items-center gap-2">
                                <i class="ri-sticky-note-line text-primary-600"></i>
                                <h6 class="text-lg mb-0">Latest Notes</h6>
                            </div>
                            <a href="{{ route('admin.notes.index') }}" class="text-sm text-primary-600">View All</a>
                        </div>
                        @if($latestNotes->count())
                            @php
                                $noteChunks = $latestNotes->chunk(3);
                            @endphp
                            <div id="latestNotesCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000">
                                <div class="carousel-inner">
                                    @foreach($noteChunks as $chunkIndex => $chunk)
                                        <div class="carousel-item {{ $chunkIndex === 0 ? 'active' : '' }}">
                                            <div class="p-20">
                                                <ul class="list-unstyled mb-0">
                                                    @foreach($chunk as $note)
                                                        <li class="mb-12 pb-12 {{ !$loop->last ? 'border-bottom' : '' }}">
                                                            <div class="d-flex align-items-start gap-12">
                                                                <div class="w-40-px h-40-px bg-primary-100 rounded-circle d-flex justify-content-center align-items-center flex-shrink-0">
                                                                    <i class="ri-sticky-note-line text-primary-600"></i>
                                                                </div>
                                                                <div class="flex-grow-1">
                                                                    <h6 class="fw-semibold text-primary-light mb-1 text-sm">{{ $note->title }}</h6>
                                                                    <p class="mb-1 text-secondary-light text-xs">{{ $note->created_at->format('d M Y') }}</p>
                                                                    <p class="mb-0 text-xs text-neutral-600">{{ \Illuminate\Support\Str::limit($note->body ?? 'No description', 50) }}</p>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                @if($noteChunks->count() > 1)
                                    <div class="carousel-indicators position-relative mt-0 mb-12" style="justify-content: center;">
                                        @foreach($noteChunks as $chunkIndex => $chunk)
                                            <button type="button" data-bs-target="#latestNotesCarousel" data-bs-slide-to="{{ $chunkIndex }}" class="{{ $chunkIndex === 0 ? 'active' : '' }}" style="width: 8px; height: 8px; border-radius: 50%; background-color: #ccc; border: none; margin: 0 4px;"></button>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        @else
                            <div class="p-20 text-center">
                                <i class="ri-sticky-note-line text-4xl text-neutral-300"></i>
                                <p class="mb-0 text-secondary-light mt-8">No notes created yet.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Current & Upcoming Sessions -->
<div class="row gy-4 mt-2">
    <div class="col-xl-7">
        <div class="card h-100">
            <div class="card-body p-0">
                <div class="d-flex flex-wrap align-items-center justify-content-between px-20 py-16 border-bottom border-neutral-200">
                    <h6 class="text-lg mb-0">Current Sessions</h6>
                    <span class="badge bg-success-100 text-success-600 text-xs px-10 py-6">{{ $currentSessions->count() }} running</span>
                </div>
                <div class="p-20">
                    @if($currentSessions->count())
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th class="text-sm">Teacher</th>
                                        <th class="text-sm">Class / Section</th>
                                        <th class="text-sm">Subject</th>
                                        <th class="text-sm">Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($currentSessions as $slot)
                                        @php
                                            $t = $slot->teacher;
                                            $photo = $t && $t->photo ? asset('storage/'.$t->photo) : asset('assets/images/thumbs/leave-request-img2.png');
                                        @endphp
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center gap-8">
                                                    <img src="{{ $photo }}" alt="Teacher" class="rounded-circle object-fit-cover" style="width:32px;height:32px;">
                                                    <span class="text-sm text-neutral-900">{{ $t->name ?? '-' }}</span>
                                                </div>
                                            </td>
                                            <td class="text-sm text-secondary-light">
                                                {{ $slot->schoolClass->name ?? '-' }}@if($slot->section) / {{ $slot->section->name }}@endif
                                            </td>
                                            <td class="text-sm text-secondary-light">
                                                {{ $slot->subject->name ?? 'Subject' }}
                                            </td>
                                            <td class="text-sm text-secondary-light">
                                                {{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }} - {{ \Carbon\Carbon::parse($slot->end_time)->format('h:i A') }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-20">
                            <i class="ri-time-line text-4xl text-neutral-300"></i>
                            <p class="mb-0 text-secondary-light mt-8">No ongoing sessions right now.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-5">
        <div class="card h-100">
            <div class="card-body p-0">
                <div class="d-flex flex-wrap align-items-center justify-content-between px-20 py-16 border-bottom border-neutral-200">
                    <h6 class="text-lg mb-0">Upcoming Sessions</h6>
                    <span class="badge bg-primary-100 text-primary-600 text-xs px-10 py-6">{{ $upcomingSessions->count() }} upcoming</span>
                </div>
                <div class="p-20">
                    @if($upcomingSessions->count())
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th class="text-sm">Class</th>
                                        <th class="text-sm">Subject</th>
                                        <th class="text-sm">Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($upcomingSessions as $slot)
                                        <tr>
                                            <td class="text-sm text-neutral-900">
                                                {{ $slot->schoolClass->name ?? '-' }}@if($slot->section) / {{ $slot->section->name }}@endif
                                            </td>
                                            <td class="text-sm text-secondary-light">
                                                {{ $slot->subject->name ?? 'Subject' }}
                                            </td>
                                            <td class="text-sm text-secondary-light">
                                                {{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-20">
                            <i class="ri-calendar-line text-4xl text-neutral-300"></i>
                            <p class="mb-0 text-secondary-light mt-8">No more sessions scheduled for today.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Leave Requests -->
<div class="row gy-4 mt-2">
    <div class="col-12">
        <div class="card h-100">
            <div class="card-body p-0">
                <div class="d-flex flex-wrap align-items-center justify-content-between px-20 py-16 border-bottom border-neutral-200">
                    <h6 class="text-lg mb-0">Recent Leave Requests</h6>
                    <a href="{{ route('admin.leave-requests.index') }}" class="text-sm text-primary-600">View All</a>
                </div>
                <div class="p-20">
                    @if($recentLeaves->count())
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th class="text-sm">User</th>
                                        <th class="text-sm">Role</th>
                                        <th class="text-sm">Student</th>
                                        <th class="text-sm">Type</th>
                                        <th class="text-sm">Date Range</th>
                                        <th class="text-sm">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentLeaves as $req)
                                        <tr>
                                            <td class="text-sm">{{ $req->user->name ?? '-' }}</td>
                                            <td class="text-capitalize text-sm text-secondary-light">{{ $req->role }}</td>
                                            <td class="text-sm text-secondary-light">{{ $req->student->name ?? '-' }}</td>
                                            <td class="text-sm text-secondary-light">{{ $req->leaveType->name ?? '-' }}</td>
                                            <td class="text-sm text-secondary-light">{{ $req->from_date->format('d M') }} - {{ $req->to_date->format('d M') }}</td>
                                            <td>
                                                @php
                                                    $status = $req->status;
                                                    $badge = 'bg-secondary-100 text-secondary-600';
                                                    if($status === 'approved') $badge = 'bg-success-100 text-success-600';
                                                    elseif($status === 'rejected') $badge = 'bg-danger-100 text-danger-600';
                                                    elseif($status === 'pending') $badge = 'bg-warning-100 text-warning-600';
                                                @endphp
                                                <span class="badge {{ $badge }}">{{ ucfirst($status) }}</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-20">
                            <i class="ri-file-list-3-line text-4xl text-neutral-300"></i>
                            <p class="mb-0 text-secondary-light mt-8">No recent leave requests.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
