@extends('layouts.admin')

@section('title', 'Add Fees Collect')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Add Fees Collect</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.fees-collection.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Fees Collect</a>
            <span class="text-secondary-light">/ Add</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.fees-collection.store') }}" method="POST" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Fees Collection Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Class
                            </label>
                            <select name="class_id" id="class_id" class="form-control form-select">
                                <option value="">Select Class</option>
                                @foreach($classes as $class)
                                <option value="{{ $class->id }}" {{ old('class_id') == $class->id ? 'selected' : '' }}>
                                    {{ $class->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Section
                            </label>
                            <select name="section_id" id="section_id" class="form-control form-select">
                                <option value="">Select Section</option>
                                @foreach($sections as $section)
                                <option value="{{ $section->id }}" {{ old('section_id') == $section->id ? 'selected' : '' }}>
                                    {{ $section->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-6 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Student <span class="text-danger-600">*</span>
                            </label>
                            <div class="d-flex gap-2 mb-2">
                                <button type="button" class="btn btn-sm btn-outline-primary" id="toggle_search_mode" onclick="toggleStudentSelection()">
                                    <i class="ri-search-line"></i> Search
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary active" id="toggle_dropdown_mode" onclick="toggleStudentSelection()">
                                    <i class="ri-list-check"></i> Dropdown
                                </button>
                            </div>
                            <!-- Search Mode -->
                            <div id="student_search_mode" class="position-relative" style="display: none;">
                                <input type="text" 
                                    id="student_search" 
                                    class="form-control" 
                                    placeholder="Search student by name, admission no, or email..."
                                    autocomplete="off"
                                    value="{{ old('student_search') }}">
                                <input type="hidden" id="student_id" name="student_id" value="{{ old('student_id') }}">
                                <div id="student_search_results" class="position-absolute w-100 bg-white border shadow-lg radius-8 mt-1" style="display: none; z-index: 1050; max-height: 300px; overflow-y: auto; left: 0; right: 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1);"></div>
                            </div>
                            <!-- Dropdown Mode -->
                            <div id="student_dropdown_mode">
                                <select id="student_id_dropdown" class="form-control form-select">
                                    <option value="">Select Student</option>
                                    @foreach($students as $student)
                                    <option value="{{ $student->id }}" 
                                        data-admission="{{ $student->admission_no ?? '' }}"
                                        {{ old('student_id') == $student->id ? 'selected' : '' }}>
                                        {{ $student->name }} ({{ $student->admission_no ?? '-' }})
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                            <small class="text-secondary-light">Select class/section to filter, then search or select student</small>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Fees Type <span class="text-danger-600">*</span>
                            </label>
                            <select name="fees_type_id" class="form-control form-select" id="fees_type_id" required>
                                <option value="">Select Fees Type</option>
                                @foreach($feesTypes as $type)
                                <option value="{{ $type->id }}" data-amount="{{ $type->amount }}" {{ old('fees_type_id') == $type->id ? 'selected' : '' }}>
                                    {{ $type->name }} ({{ number_format($type->amount, 2) }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Fees Discount
                            </label>
                            <select name="fees_discount_id" class="form-control form-select">
                                <option value="">Select Discount</option>
                                @foreach($feesDiscounts as $discount)
                                <option value="{{ $discount->id }}" {{ old('fees_discount_id') == $discount->id ? 'selected' : '' }}>
                                    {{ $discount->name }} ({{ ucfirst($discount->type) }} {{ number_format($discount->amount, 2) }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Total Amount <span class="text-danger-600">*</span>
                            </label>
                            <input type="number" step="0.01" name="amount" id="amount" class="form-control" value="{{ old('amount') }}" required>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Discount Amount
                            </label>
                            <input type="number" step="0.01" name="discount_amount" class="form-control" value="{{ old('discount_amount', 0) }}">
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Paid Amount <span class="text-danger-600">*</span>
                            </label>
                            <input type="number" step="0.01" name="paid_amount" class="form-control" value="{{ old('paid_amount') }}" required>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Payment Date <span class="text-danger-600">*</span>
                            </label>
                            <input type="date" name="payment_date" id="payment_date" class="form-control" value="{{ old('payment_date', now()->toDateString()) }}" required>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Payment Method
                            </label>
                            <input type="text" name="payment_method" class="form-control" value="{{ old('payment_method') }}" placeholder="Cash / Card / UPI etc">
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Reference
                            </label>
                            <input type="text" name="reference" class="form-control" value="{{ old('reference') }}" placeholder="Transaction reference">
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Notes
                            </label>
                            <textarea name="notes" rows="3" class="form-control" placeholder="Optional notes">{{ old('notes') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.fees-collection.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save
                </button>
            </div>
        </div>
    </div>
</form>
@endsection
@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const feesTypeSelect = document.getElementById('fees_type_id');
        const amountInput = document.getElementById('amount');
        if (!feesTypeSelect || !amountInput) return;

        function updateAmount() {
            const opt = feesTypeSelect.selectedOptions[0];
            if (!opt) return;
            const val = opt.getAttribute('data-amount');
            if (val !== null && val !== '') {
                amountInput.value = val;
            }
        }

        feesTypeSelect.addEventListener('change', updateAmount);
        // initial
        updateAmount();

        // Student search functionality
        const studentSearch = document.getElementById('student_search');
        const studentSearchResults = document.getElementById('student_search_results');
        const studentIdInput = document.getElementById('student_id');
        const studentDropdown = document.getElementById('student_id_dropdown');
        const studentSearchMode = document.getElementById('student_search_mode');
        const studentDropdownMode = document.getElementById('student_dropdown_mode');
        const paymentDateInput = document.getElementById('payment_date');
        const classSelect = document.getElementById('class_id');
        const sectionSelect = document.getElementById('section_id');
        let searchTimeout;
        let isSearchMode = false; // Default to dropdown mode

        // Auto-set payment date to today when student is selected
        function setPaymentDate() {
            if (paymentDateInput && !paymentDateInput.value) {
                const today = new Date().toISOString().split('T')[0];
                paymentDateInput.value = today;
            }
        }

        if (studentSearch) {
            studentSearch.addEventListener('input', function() {
                const query = this.value.trim();
                
                clearTimeout(searchTimeout);
                
                if (query.length < 1) {
                    studentSearchResults.style.display = 'none';
                    return;
                }

                searchTimeout = setTimeout(() => {
                    const classId = classSelect ? classSelect.value : '';
                    const sectionId = sectionSelect ? sectionSelect.value : '';
                    const baseUrl = window.location.origin;
                    // Fix URL construction - ensure proper parameter encoding
                    let searchUrl = `${baseUrl}/admin/fees-collection/search-students?q=${encodeURIComponent(query)}`;
                    if (classId) searchUrl += `&class_id=${encodeURIComponent(classId)}`;
                    if (sectionId) searchUrl += `&section_id=${encodeURIComponent(sectionId)}`;
                    console.log('Search URL:', searchUrl);
                    
                    // Show loading
                    studentSearchResults.innerHTML = '<div class="p-2 text-secondary-light"><i class="ri-loader-4-line ri-spin"></i> Searching...</div>';
                    studentSearchResults.style.display = 'block';
                    
                    fetch(searchUrl, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest',
                        },
                        credentials: 'same-origin'
                    })
                        .then(response => {
                            if (!response.ok) {
                                throw new Error(`HTTP error! status: ${response.status}`);
                            }
                            return response.json();
                        })
                        .then(data => {
                            if (data && Array.isArray(data) && data.length > 0) {
                                let html = '';
                                data.forEach(student => {
                                    const escapedName = String(student.name || '').replace(/'/g, "\\'").replace(/"/g, '&quot;').replace(/\n/g, ' ');
                                    html += `<div class="p-3 border-bottom cursor-pointer" 
                                                onclick="selectStudent(${student.id}, '${escapedName}', '${student.admission_no || ''}')"
                                                onmouseover="this.style.backgroundColor='#f8f9fa'" 
                                                onmouseout="this.style.backgroundColor='transparent'"
                                                style="transition: background-color 0.2s;">
                                                <div class="fw-semibold text-primary-light">${student.name || 'N/A'}</div>
                                                <div class="text-sm text-secondary-light">Admission: ${student.admission_no || 'N/A'}</div>
                                                <div class="text-xs text-secondary-light mt-1">${student.class} - ${student.section}</div>
                                            </div>`;
                                });
                                studentSearchResults.innerHTML = html;
                                studentSearchResults.style.display = 'block';
                            } else {
                                studentSearchResults.innerHTML = '<div class="p-3 text-secondary-light text-center">No students found matching "' + query + '"</div>';
                                studentSearchResults.style.display = 'block';
                            }
                        })
                        .catch(error => {
                            console.error('Search error:', error);
                            studentSearchResults.innerHTML = '<div class="p-3 text-danger text-center">Error searching students. Please try again.</div>';
                            studentSearchResults.style.display = 'block';
                        });
                }, 300);
            });

            // Hide results when clicking outside
            document.addEventListener('click', function(e) {
                if (!studentSearch.contains(e.target) && !studentSearchResults.contains(e.target)) {
                    studentSearchResults.style.display = 'none';
                }
            });
        }

        window.selectStudent = function(id, name, admissionNo) {
            studentIdInput.value = id;
            if (studentSearch) {
                studentSearch.value = name + ' (' + admissionNo + ')';
            }
            if (studentSearchResults) {
                studentSearchResults.style.display = 'none';
            }
            
            // Auto-set payment date
            setPaymentDate();
        };

        // Toggle between search and dropdown mode
        window.toggleStudentSelection = function() {
            isSearchMode = !isSearchMode;
            
            if (isSearchMode) {
                // Show search, hide dropdown
                if (studentSearchMode) studentSearchMode.style.display = 'block';
                if (studentDropdownMode) studentDropdownMode.style.display = 'none';
                if (document.getElementById('toggle_search_mode')) {
                    document.getElementById('toggle_search_mode').classList.add('btn-primary');
                    document.getElementById('toggle_search_mode').classList.remove('btn-outline-primary');
                }
                if (document.getElementById('toggle_dropdown_mode')) {
                    document.getElementById('toggle_dropdown_mode').classList.remove('btn-secondary');
                    document.getElementById('toggle_dropdown_mode').classList.add('btn-outline-secondary');
                }
            } else {
                // Show dropdown, hide search
                if (studentSearchMode) studentSearchMode.style.display = 'none';
                if (studentDropdownMode) studentDropdownMode.style.display = 'block';
                if (document.getElementById('toggle_search_mode')) {
                    document.getElementById('toggle_search_mode').classList.remove('btn-primary');
                    document.getElementById('toggle_search_mode').classList.add('btn-outline-primary');
                }
                if (document.getElementById('toggle_dropdown_mode')) {
                    document.getElementById('toggle_dropdown_mode').classList.add('btn-secondary');
                    document.getElementById('toggle_dropdown_mode').classList.remove('btn-outline-secondary');
                }
                // Load students for dropdown when switching to dropdown mode
                loadStudentsForDropdown();
            }
        };

        // Load students for dropdown based on class/section filters
        function loadStudentsForDropdown() {
            if (!studentDropdown) return;
            
            const classId = classSelect ? classSelect.value : '';
            const sectionId = sectionSelect ? sectionSelect.value : '';
            const baseUrl = window.location.origin;
            const searchUrl = `${baseUrl}/admin/fees-collection/search-students?q=&class_id=${classId}&section_id=${sectionId}`;
            
            // Clear existing options except the first one
            studentDropdown.innerHTML = '<option value="">Select Student</option>';
            
            fetch(searchUrl, {
                method: 'GET',
                headers: {
                    'Accept': 'application/json',
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest',
                },
                credentials: 'same-origin'
            })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    return response.json();
                })
                .then(data => {
                    if (data && Array.isArray(data)) {
                        data.forEach(student => {
                            const option = document.createElement('option');
                            option.value = student.id;
                            option.textContent = `${student.name} (${student.admission_no || '-'})`;
                            option.setAttribute('data-admission', student.admission_no || '');
                            if (studentIdInput && studentIdInput.value == student.id) {
                                option.selected = true;
                            }
                            studentDropdown.appendChild(option);
                        });
                    }
                })
                .catch(error => {
                    console.error('Error loading students:', error);
                });
        }

        // Handle dropdown change
        if (studentDropdown) {
            studentDropdown.addEventListener('change', function() {
                studentIdInput.value = this.value;
                setPaymentDate();
            });
        }

        // Filter students when class/section changes
        if (classSelect) {
            classSelect.addEventListener('change', function() {
                studentIdInput.value = '';
                if (studentSearch) studentSearch.value = '';
                if (studentDropdown) studentDropdown.value = '';
                // Reload dropdown if in dropdown mode
                if (!isSearchMode) {
                    loadStudentsForDropdown();
                }
            });
        }
        if (sectionSelect) {
            sectionSelect.addEventListener('change', function() {
                studentIdInput.value = '';
                if (studentSearch) studentSearch.value = '';
                if (studentDropdown) studentDropdown.value = '';
                // Reload dropdown if in dropdown mode
                if (!isSearchMode) {
                    loadStudentsForDropdown();
                }
            });
        }

        // Set payment date if student is already selected
        @if(old('student_id'))
            setPaymentDate();
        @endif

        // Initialize button states - default to dropdown mode
        if (!isSearchMode) {
            if (document.getElementById('toggle_search_mode')) {
                document.getElementById('toggle_search_mode').classList.remove('btn-primary');
                document.getElementById('toggle_search_mode').classList.add('btn-outline-primary');
            }
            if (document.getElementById('toggle_dropdown_mode')) {
                document.getElementById('toggle_dropdown_mode').classList.add('btn-secondary');
                document.getElementById('toggle_dropdown_mode').classList.remove('btn-outline-secondary');
            }
        }

        // Sync dropdown value with hidden input on page load
        if (studentDropdown && studentIdInput && studentIdInput.value) {
            studentDropdown.value = studentIdInput.value;
        }
    });
</script>
@endsection
