@extends('layouts.admin')

@section('title', 'Fees Collect')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Fees Collect</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Fees Collect</span>
        </div>
    </div>
    <a href="{{ route('admin.fees-collection.create') }}" class="btn btn-primary-600 d-flex align-items-center gap-6">
        <span class="d-flex text-md">
            <i class="ri-add-large-line"></i>
        </span>
        Add Fees Collect
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="mt-24">
    <div class="card h-100">
        <div class="card-body p-0 dataTable-wrapper">
            <div class="p-0">
                <table class="table bordered-table mb-0 data-table" id="dataTable" data-page-length='20'>
                    <thead>
                        <tr>
                            <th scope="col">S.L</th>
                            <th scope="col">Date</th>
                            <th scope="col">Student</th>
                            <th scope="col">Fees Type</th>
                            <th scope="col">Amount</th>
                            <th scope="col">Paid</th>
                            <th scope="col">Method</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($collections as $index => $c)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ \Carbon\Carbon::parse($c->payment_date)->format('d M Y') }}</td>
                            <td>{{ $c->student ? $c->student->name : '-' }}</td>
                            <td>{{ $c->feesType ? $c->feesType->name : '-' }}</td>
                            <td>{{ number_format($c->amount, 2) }}</td>
                            <td>{{ number_format($c->paid_amount, 2) }}</td>
                            <td>{{ $c->payment_method ?? '-' }}</td>
                            <td class="d-flex flex-wrap gap-2">
                                <a href="{{ route('admin.fees-collection.show', $c->id) }}" class="btn btn-sm btn-success">
                                    Receipt
                                </a>
                                <a href="{{ route('admin.fees-collection.edit', $c->id) }}" class="btn btn-sm btn-primary-600">
                                    Edit
                                </a>
                                <form action="{{ route('admin.fees-collection.destroy', $c->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                        class="btn btn-sm btn-danger-600"
                                        onclick="return confirm('Are you sure you want to delete this fees record?');">
                                        Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center">No fees collection records found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection


