@extends('layouts.admin')

@section('title', 'Add Fees Discount')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Add Fees Discount</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.fees-discount.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Fees Discount</a>
            <span class="text-secondary-light">/ Add</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.fees-discount.store') }}" method="POST" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Fees Discount Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Name <span class="text-danger-600">*</span>
                            </label>
                            <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Type <span class="text-danger-600">*</span>
                            </label>
                            <select name="type" class="form-control form-select" required>
                                <option value="fixed" {{ old('type') == 'fixed' ? 'selected' : '' }}>Fixed</option>
                                <option value="percentage" {{ old('type') == 'percentage' ? 'selected' : '' }}>Percentage</option>
                            </select>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Amount <span class="text-danger-600">*</span>
                            </label>
                            <input type="number" step="0.01" name="amount" class="form-control" value="{{ old('amount') }}" required>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6 d-flex align-items-end">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="1" id="is_active" name="is_active" {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active
                                </label>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Description
                            </label>
                            <textarea name="description" rows="3" class="form-control" placeholder="Optional description">{{ old('description') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.fees-discount.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save
                </button>
            </div>
        </div>
    </div>
</form>
@endsection



