@extends('layouts.admin')

@section('title', 'Edit Fees Type')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Fees Type</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.fees-type.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Fees Type</a>
            <span class="text-secondary-light">/ Edit</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.fees-type.update', $type->id) }}" method="POST" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Fees Type Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Name <span class="text-danger-600">*</span>
                            </label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $type->name) }}" required>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Amount <span class="text-danger-600">*</span>
                            </label>
                            <input type="number" step="0.01" name="amount" class="form-control" value="{{ old('amount', $type->amount) }}" required>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6 d-flex align-items-end">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="1" id="is_active" name="is_active" {{ old('is_active', $type->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active
                                </label>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Description
                            </label>
                            <textarea name="description" rows="3" class="form-control" placeholder="Optional description">{{ old('description', $type->description) }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recurring Fee Section -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">
                        <i class="ri-loop-right-line me-2 text-primary-600"></i>
                        Recurring Fee Settings
                    </h6>
                    @if($type->last_generated_date)
                        <span class="badge bg-success-100 text-success-600">
                            Last Generated: {{ $type->last_generated_date->format('d M Y') }}
                        </span>
                    @endif
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-12">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="is_recurring" name="is_recurring" value="1" {{ old('is_recurring', $type->is_recurring) ? 'checked' : '' }}>
                                <label class="form-check-label fw-semibold" for="is_recurring">
                                    Enable Recurring Fee
                                </label>
                            </div>
                            <small class="text-secondary-light">Enable this to automatically generate fees on a schedule</small>
                        </div>
                        
                        <div id="recurring-options" style="display: {{ old('is_recurring', $type->is_recurring) ? 'block' : 'none' }};">
                            <div class="row gy-3 mt-8">
                                <div class="col-md-3">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                        Frequency <span class="text-danger-600">*</span>
                                    </label>
                                    <select name="recurring_frequency" class="form-control form-select">
                                        <option value="monthly" {{ old('recurring_frequency', $type->recurring_frequency) == 'monthly' ? 'selected' : '' }}>Monthly</option>
                                        <option value="quarterly" {{ old('recurring_frequency', $type->recurring_frequency) == 'quarterly' ? 'selected' : '' }}>Quarterly (Every 3 months)</option>
                                        <option value="yearly" {{ old('recurring_frequency', $type->recurring_frequency) == 'yearly' ? 'selected' : '' }}>Yearly</option>
                                        <option value="one_time" {{ old('recurring_frequency', $type->recurring_frequency) == 'one_time' ? 'selected' : '' }}>One Time</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                        Generate on Day <span class="text-danger-600">*</span>
                                    </label>
                                    <select name="recurring_day" class="form-control form-select">
                                        @for($i = 1; $i <= 28; $i++)
                                            <option value="{{ $i }}" {{ old('recurring_day', $type->recurring_day) == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                    <small class="text-secondary-light">Day of month to generate fee</small>
                                </div>
                                <div class="col-md-3">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                        Start Date
                                    </label>
                                    <input type="date" name="recurring_start_date" class="form-control" value="{{ old('recurring_start_date', $type->recurring_start_date?->format('Y-m-d')) }}">
                                </div>
                                <div class="col-md-3">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                        End Date
                                    </label>
                                    <input type="date" name="recurring_end_date" class="form-control" value="{{ old('recurring_end_date', $type->recurring_end_date?->format('Y-m-d')) }}">
                                    <small class="text-secondary-light">Leave empty for no end date</small>
                                </div>
                                <div class="col-12 mt-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="auto_generate" name="auto_generate" value="1" {{ old('auto_generate', $type->auto_generate) ? 'checked' : '' }}>
                                        <label class="form-check-label fw-semibold" for="auto_generate">
                                            Auto Generate Fees
                                        </label>
                                    </div>
                                    <small class="text-secondary-light">Automatically create fee records for assigned students on the scheduled day</small>
                                </div>
                            </div>
                            
                            <div class="alert alert-info mt-16 mb-0">
                                <i class="ri-information-line me-2"></i>
                                <strong>How it works:</strong> When enabled, the system will automatically generate fee entries for all students assigned to this fee type on the specified day each month/period.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.fees-type.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Update
                </button>
            </div>
        </div>
    </div>
</form>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const isRecurringCheckbox = document.getElementById('is_recurring');
    const recurringOptions = document.getElementById('recurring-options');
    
    function toggleRecurringOptions() {
        if (isRecurringCheckbox.checked) {
            recurringOptions.style.display = 'block';
        } else {
            recurringOptions.style.display = 'none';
        }
    }
    
    isRecurringCheckbox.addEventListener('change', toggleRecurringOptions);
});
</script>
@endsection



