@extends('layouts.admin')

@section('title', 'Review Leave Request')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Review Leave Request</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.leave-requests.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Leave Requests</a>
            <span class="text-secondary-light">/ Review</span>
        </div>
    </div>
</div>

@if($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('admin.leave-requests.update', $leaveRequest->id) }}" method="POST" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Request Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3 text-sm text-secondary-light">
                        <div class="col-md-4">
                            <p class="mb-1"><span class="fw-semibold text-neutral-800">User:</span> {{ $leaveRequest->user->name ?? '-' }}</p>
                            <p class="mb-1"><span class="fw-semibold text-neutral-800">Role:</span> {{ ucfirst($leaveRequest->role) }}</p>
                        </div>
                        <div class="col-md-4">
                            <p class="mb-1"><span class="fw-semibold text-neutral-800">Student:</span> {{ $leaveRequest->student->name ?? '-' }}</p>
                            <p class="mb-1"><span class="fw-semibold text-neutral-800">Type:</span> {{ $leaveRequest->leaveType->name ?? '-' }}</p>
                        </div>
                        <div class="col-md-4">
                            <p class="mb-1"><span class="fw-semibold text-neutral-800">From:</span> {{ $leaveRequest->from_date->format('d M Y') }}</p>
                            <p class="mb-1"><span class="fw-semibold text-neutral-800">To:</span> {{ $leaveRequest->to_date->format('d M Y') }}</p>
                        </div>
                        <div class="col-12">
                            <p class="mb-1"><span class="fw-semibold text-neutral-800">Reason:</span> {{ $leaveRequest->reason ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="row gy-3 mt-3">
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Status</label>
                            <select name="status" class="form-select">
                                @foreach(['pending','approved','rejected'] as $status)
                                    <option value="{{ $status }}" {{ $leaveRequest->status === $status ? 'selected' : '' }}>{{ ucfirst($status) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Leave Type (optional override)</label>
                            <select name="leave_type_id" class="form-select">
                                <option value="">Keep as is</option>
                                @foreach($leaveTypes as $type)
                                    <option value="{{ $type->id }}" {{ $leaveRequest->leave_type_id == $type->id ? 'selected' : '' }}>
                                        {{ $type->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Admin Remarks</label>
                            <textarea name="admin_remarks" rows="3" class="form-control">{{ old('admin_remarks', $leaveRequest->admin_remarks) }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.leave-requests.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save
                </button>
            </div>
        </div>
    </div>
</form>
@endsection


