@extends('layouts.admin')

@section('title', 'Note Board')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Note Board</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Note Board</span>
        </div>
    </div>
    <a href="{{ route('admin.notes.create') }}" class="btn btn-primary-600">Add Note</a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
    <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
        <h6 class="text-lg fw-semibold mb-0">Notes</h6>
    </div>
    <div class="card-body p-20">
        @if($notes->count())
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>For</th>
                            <th>Created</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($notes as $note)
                        <tr>
                            <td class="fw-semibold text-primary-light">{{ $note->title }}</td>
                            <td>
                                @if($note->for_all)
                                    <span class="badge bg-primary-subtle text-primary">All Classes</span>
                                @else
                                    <span class="badge bg-secondary-subtle text-secondary">{{ $note->schoolClass->name ?? 'Class' }}</span>
                                @endif
                            </td>
                            <td>{{ $note->created_at->format('d M Y') }}</td>
                            <td class="text-end">
                                <a href="{{ route('admin.notes.edit', $note->id) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                                <form action="{{ route('admin.notes.destroy', $note->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this note?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-12">
                {{ $notes->links() }}
            </div>
        @else
            <p class="mb-0 text-secondary-light">No notes yet.</p>
        @endif
    </div>
</div>
@endsection


