@extends('layouts.admin')

@section('title', 'Send Notification')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Send Notification</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/</span>
            <a href="{{ route('admin.notifications.index') }}" class="text-secondary-light hover-text-primary hover-underline">Notifications</a>
            <span class="text-secondary-light">/ Send New</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.notifications.store') }}" method="POST">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-8">
            <div class="card shadow-sm radius-12 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">Notification Details</h6>
                </div>
                <div class="card-body p-24">
                    <div class="row gy-3">
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Notification Type <span class="text-danger-600">*</span>
                            </label>
                            <select name="type" class="form-select" required>
                                @foreach($types as $key => $config)
                                <option value="{{ $key }}" {{ old('type') == $key ? 'selected' : '' }}>
                                    {{ ucfirst($key) }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Title <span class="text-danger-600">*</span>
                            </label>
                            <input type="text" name="title" class="form-control" required 
                                   value="{{ old('title') }}" placeholder="Enter notification title">
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Message <span class="text-danger-600">*</span>
                            </label>
                            <textarea name="message" class="form-control" rows="4" required 
                                      placeholder="Enter notification message">{{ old('message') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow-sm radius-12 overflow-hidden mb-3">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">Target Audience</h6>
                </div>
                <div class="card-body p-24">
                    <div class="row gy-3">
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Send To <span class="text-danger-600">*</span>
                            </label>
                            <select name="target" id="target" class="form-select" required onchange="toggleTargetFields()">
                                <option value="all" {{ old('target') == 'all' ? 'selected' : '' }}>All Parents</option>
                                <option value="class" {{ old('target') == 'class' ? 'selected' : '' }}>Specific Class</option>
                                <option value="student" {{ old('target') == 'student' ? 'selected' : '' }}>Specific Student</option>
                                <option value="parent" {{ old('target') == 'parent' ? 'selected' : '' }}>Specific Parent</option>
                            </select>
                        </div>

                        <div class="col-12" id="class-field" style="display: none;">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Select Class
                            </label>
                            <select name="class_id" class="form-select">
                                <option value="">Choose class...</option>
                                @foreach($classes as $class)
                                <option value="{{ $class->id }}" {{ old('class_id') == $class->id ? 'selected' : '' }}>
                                    {{ $class->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12" id="student-field" style="display: none;">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Select Student
                            </label>
                            <select name="student_id" class="form-select">
                                <option value="">Choose student...</option>
                                @foreach($students as $student)
                                <option value="{{ $student->id }}" {{ old('student_id') == $student->id ? 'selected' : '' }}>
                                    {{ $student->name }} ({{ $student->admission_no }})
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12" id="parent-field" style="display: none;">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Select Parent
                            </label>
                            <select name="parent_id" class="form-select">
                                <option value="">Choose parent...</option>
                                @foreach($parents as $parent)
                                <option value="{{ $parent->id }}" {{ old('parent_id') == $parent->id ? 'selected' : '' }}>
                                    {{ $parent->name }} ({{ $parent->email }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm radius-12 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">Schedule (Optional)</h6>
                </div>
                <div class="card-body p-24">
                    <div class="row gy-3">
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Schedule For
                            </label>
                            <input type="datetime-local" name="scheduled_at" class="form-control" 
                                   value="{{ old('scheduled_at') }}">
                            <small class="text-secondary-light">Leave empty to send immediately</small>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Expires At
                            </label>
                            <input type="datetime-local" name="expires_at" class="form-control" 
                                   value="{{ old('expires_at') }}">
                            <small class="text-secondary-light">Leave empty for no expiration</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.notifications.index') }}" 
                   class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit" class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    <i class="ri-send-plane-line me-2"></i> Send Notification
                </button>
            </div>
        </div>
    </div>
</form>

<script>
function toggleTargetFields() {
    const target = document.getElementById('target').value;
    document.getElementById('class-field').style.display = target === 'class' ? 'block' : 'none';
    document.getElementById('student-field').style.display = target === 'student' ? 'block' : 'none';
    document.getElementById('parent-field').style.display = target === 'parent' ? 'block' : 'none';
}

// Run on page load
document.addEventListener('DOMContentLoaded', toggleTargetFields);
</script>
@endsection
