@extends('layouts.admin')

@section('title', 'Edit Notification')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Notification</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/</span>
            <a href="{{ route('admin.notifications.index') }}" class="text-secondary-light hover-text-primary hover-underline">Notifications</a>
            <span class="text-secondary-light">/ Edit</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.notifications.update', $notification->id) }}" method="POST">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-8">
            <div class="card shadow-sm radius-12 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">Notification Details</h6>
                </div>
                <div class="card-body p-24">
                    <div class="row gy-3">
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Notification Type <span class="text-danger-600">*</span>
                            </label>
                            <select name="type" class="form-select" required>
                                @foreach($types as $key => $config)
                                <option value="{{ $key }}" {{ $notification->type == $key ? 'selected' : '' }}>
                                    {{ ucfirst($key) }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Title <span class="text-danger-600">*</span>
                            </label>
                            <input type="text" name="title" class="form-control" required 
                                   value="{{ old('title', $notification->title) }}" placeholder="Enter notification title">
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Message <span class="text-danger-600">*</span>
                            </label>
                            <textarea name="message" class="form-control" rows="4" required 
                                      placeholder="Enter notification message">{{ old('message', $notification->message) }}</textarea>
                        </div>
                        <div class="col-12">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="is_active" value="1" 
                                       id="is_active" {{ $notification->is_active ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">Active</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow-sm radius-12 overflow-hidden mb-3">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">Target Audience</h6>
                </div>
                <div class="card-body p-24">
                    @php
                        $currentTarget = 'all';
                        if ($notification->class_id) $currentTarget = 'class';
                        elseif ($notification->student_id) $currentTarget = 'student';
                        elseif ($notification->parent_id) $currentTarget = 'parent';
                    @endphp
                    <div class="row gy-3">
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Send To <span class="text-danger-600">*</span>
                            </label>
                            <select name="target" id="target" class="form-select" required onchange="toggleTargetFields()">
                                <option value="all" {{ $currentTarget == 'all' ? 'selected' : '' }}>All Parents</option>
                                <option value="class" {{ $currentTarget == 'class' ? 'selected' : '' }}>Specific Class</option>
                                <option value="student" {{ $currentTarget == 'student' ? 'selected' : '' }}>Specific Student</option>
                                <option value="parent" {{ $currentTarget == 'parent' ? 'selected' : '' }}>Specific Parent</option>
                            </select>
                        </div>

                        <div class="col-12" id="class-field" style="display: {{ $currentTarget == 'class' ? 'block' : 'none' }};">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Select Class
                            </label>
                            <select name="class_id" class="form-select">
                                <option value="">Choose class...</option>
                                @foreach($classes as $class)
                                <option value="{{ $class->id }}" {{ $notification->class_id == $class->id ? 'selected' : '' }}>
                                    {{ $class->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12" id="student-field" style="display: {{ $currentTarget == 'student' ? 'block' : 'none' }};">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Select Student
                            </label>
                            <select name="student_id" class="form-select">
                                <option value="">Choose student...</option>
                                @foreach($students as $student)
                                <option value="{{ $student->id }}" {{ $notification->student_id == $student->id ? 'selected' : '' }}>
                                    {{ $student->name }} ({{ $student->admission_no }})
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12" id="parent-field" style="display: {{ $currentTarget == 'parent' ? 'block' : 'none' }};">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Select Parent
                            </label>
                            <select name="parent_id" class="form-select">
                                <option value="">Choose parent...</option>
                                @foreach($parents as $parent)
                                <option value="{{ $parent->id }}" {{ $notification->parent_id == $parent->id ? 'selected' : '' }}>
                                    {{ $parent->name }} ({{ $parent->email }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm radius-12 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">Schedule (Optional)</h6>
                </div>
                <div class="card-body p-24">
                    <div class="row gy-3">
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Schedule For
                            </label>
                            <input type="datetime-local" name="scheduled_at" class="form-control" 
                                   value="{{ $notification->scheduled_at ? $notification->scheduled_at->format('Y-m-d\TH:i') : '' }}">
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Expires At
                            </label>
                            <input type="datetime-local" name="expires_at" class="form-control" 
                                   value="{{ $notification->expires_at ? $notification->expires_at->format('Y-m-d\TH:i') : '' }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.notifications.index') }}" 
                   class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit" class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    <i class="ri-save-line me-2"></i> Update Notification
                </button>
            </div>
        </div>
    </div>
</form>

<script>
function toggleTargetFields() {
    const target = document.getElementById('target').value;
    document.getElementById('class-field').style.display = target === 'class' ? 'block' : 'none';
    document.getElementById('student-field').style.display = target === 'student' ? 'block' : 'none';
    document.getElementById('parent-field').style.display = target === 'parent' ? 'block' : 'none';
}
</script>
@endsection
