@extends('layouts.admin')

@section('title', 'Parent List')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Parent List</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Parents</span>
        </div>
    </div>
    <a href="{{ route('admin.parent.create') }}" class="btn btn-primary-600 d-flex align-items-center gap-6">
        <span class="d-flex text-md">
            <i class="ri-add-large-line"></i>
        </span>
        Add Parent
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="mt-24">
    <div class="card h-100">
        <div class="card-body p-0 dataTable-wrapper">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-16 px-20 py-12 border-bottom border-neutral-200">
                <div class="d-flex flex-wrap align-items-center gap-16">
                    <form class="navbar-search dt-search m-0" method="GET" action="{{ route('admin.parent.index') }}">
                        <input type="text" class="dt-input bg-transparent radius-4" name="search"
                            placeholder="Search by name or email..." value="{{ $search }}">
                        <iconify-icon icon="ion:search-outline" class="icon"></iconify-icon>
                    </form>
                </div>
            </div>

            <div class="p-0">
                <table class="table bordered-table mb-0 data-table" id="dataTable" data-page-length='10'>
                    <thead>
                        <tr>
                            <th scope="col">S.L</th>
                            <th scope="col">Photo</th>
                            <th scope="col">Name</th>
                            <th scope="col">Email</th>
                            <th scope="col">Children</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($parents as $index => $parent)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>
                                @php
                                    $photoPath = $parent->photo ? asset('storage/'.$parent->photo) : asset('assets/images/thumbs/leave-request-img2.png');
                                @endphp
                                <img src="{{ $photoPath }}" alt="Parent Photo" class="rounded-circle object-fit-cover" style="width: 40px; height: 40px;">
                            </td>
                            <td>{{ $parent->name }}</td>
                            <td>{{ $parent->email }}</td>
                            <td>
                                @if($parent->students_count > 0)
                                    <span class="fw-medium">{{ $parent->students_count }} Student(s)</span>
                                @else
                                    <span class="text-secondary-light">No linked students</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="text-primary-light text-xl"
                                        data-bs-toggle="dropdown" data-bs-display="static"
                                        aria-expanded="false">
                                        <iconify-icon icon="tabler:dots-vertical"></iconify-icon>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-lg-end border p-12">
                                        <li>
                                            <a href="{{ route('admin.parent.edit', $parent->id) }}"
                                                class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6">
                                                <i class="ri-pencil-line"></i>
                                                Edit
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('admin.parent.show', $parent->id) }}"
                                                class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6">
                                                <i class="ri-eye-line"></i>
                                                View Details
                                            </a>
                                        </li>
                                        <li>
                                            <form action="{{ route('admin.parent.destroy', $parent->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                    class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6 w-100 text-start border-0 bg-transparent"
                                                    onclick="return confirm('Are you sure you want to delete this parent? This will detach linked students.');">
                                                    <i class="ri-delete-bin-6-line"></i>
                                                    Delete
                                                </button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center">No parents found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection


