@extends('layouts.admin')

@section('title', 'Parent Details')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Parent Details</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.parent.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Parents</a>
            <span class="text-secondary-light">/ Parent Details</span>
        </div>
    </div>
</div>

<div class="row gy-3">
    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Parent Information</h6>
            </div>
            <div class="card-body p-20">
                <div class="row gy-3 align-items-center">
                    <div class="col-md-3 text-center">
                        @php
                            $photoPath = $parent->photo ? asset('storage/'.$parent->photo) : asset('assets/images/thumbs/leave-request-img2.png');
                        @endphp
                        <img src="{{ $photoPath }}" alt="Parent Photo" class="rounded-circle object-fit-cover mb-12" style="width: 96px; height: 96px;">
                    </div>
                    <div class="col-md-9">
                        <div class="row gy-3">
                            <div class="col-md-6">
                                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Name</label>
                                <p class="text-md fw-medium">{{ $parent->name }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Email</label>
                                <p class="text-md fw-medium">{{ $parent->email }}</p>
                            </div>
                            @if($parent->phone)
                                <div class="col-md-6">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Phone</label>
                                    <p class="text-md fw-medium">{{ $parent->phone }}</p>
                                </div>
                            @endif
                            @if($parent->occupation)
                                <div class="col-md-6">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Occupation</label>
                                    <p class="text-md fw-medium">{{ $parent->occupation }}</p>
                                </div>
                            @endif
                            @if($parent->address)
                                <div class="col-md-12">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Address</label>
                                    <p class="text-md fw-medium">{{ $parent->address }}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Children (Students)</h6>
            </div>
            <div class="card-body p-20">
                @if($parent->students->count() > 0)
                <div class="table-responsive">
                    <table class="table bordered-table mb-0">
                        <thead>
                            <tr>
                                <th scope="col">Admission No</th>
                                <th scope="col">Name</th>
                                <th scope="col">Class</th>
                                <th scope="col">Section</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($parent->students as $student)
                            <tr>
                                <td>{{ $student->admission_no }}</td>
                                <td>{{ $student->name }}</td>
                                <td>{{ $student->schoolClass ? $student->schoolClass->name : 'N/A' }}</td>
                                <td>{{ $student->section ? $student->section->name : 'N/A' }}</td>
                                <td>
                                    <a href="{{ route('admin.student.show', $student->id) }}" 
                                       class="btn btn-sm btn-primary-600" 
                                       style="pointer-events: auto !important; cursor: pointer !important; z-index: 10 !important; position: relative !important;">
                                        View
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <p class="text-secondary-light mb-0">No students linked to this parent.</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection


