@extends('layouts.admin')

@section('title', 'Push Notification Settings')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Push Notification Settings</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Push Notifications</span>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.settings.notifications.update') }}" method="POST" enctype="multipart/form-data" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Firebase Cloud Messaging (FCM v1 API)</h6>
                </div>
                <div class="card-body p-20">
                    <div class="alert alert-info mb-20">
                        <h6 class="mb-8"><i class="ri-information-line me-2"></i>How to setup Firebase Push Notifications (FCM v1 API):</h6>
                        <ol class="mb-0 ps-16">
                            <li>Go to <a href="https://console.firebase.google.com/" target="_blank" class="text-primary-600">Firebase Console</a></li>
                            <li>Create a new project or select existing one</li>
                            <li>Go to <strong>Project Settings > Service Accounts</strong></li>
                            <li>Click <strong>"Generate new private key"</strong> to download the JSON file</li>
                            <li>Upload that JSON file below</li>
                            <li>Download <code>google-services.json</code> from Project Settings > General and add to your Flutter Android app</li>
                        </ol>
                    </div>

                    <div class="row gy-3">
                        <div class="col-12">
                            <div class="form-check form-switch mb-16">
                                <input class="form-check-input" type="checkbox" name="push_notifications_enabled" value="1" 
                                       id="push_notifications_enabled" {{ ($setting->push_notifications_enabled ?? true) ? 'checked' : '' }}>
                                <label class="form-check-label fw-semibold" for="push_notifications_enabled">
                                    Enable Push Notifications
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Firebase Project ID
                            </label>
                            <input type="text" name="fcm_project_id" class="form-control" 
                                   value="{{ old('fcm_project_id', $setting->fcm_project_id ?? '') }}"
                                   placeholder="your-project-id">
                            <small class="text-secondary-light">Auto-filled when you upload the service account file</small>
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Service Account JSON File
                            </label>
                            <input type="file" name="service_account_file" class="form-control" accept=".json">
                            <small class="text-secondary-light">Download from Firebase Console > Project Settings > Service Accounts</small>
                            @if(file_exists(storage_path('app/private/firebase-service-account.json')))
                                <span class="badge bg-success-100 text-success-600 mt-8">
                                    <i class="ri-check-line me-1"></i> Service account file uploaded
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden mt-3">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">Notification Events</h6>
                </div>
                <div class="card-body p-20">
                    <p class="text-secondary-light mb-16">Push notifications are automatically sent for the following events:</p>
                    <div class="row gy-3">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center gap-3 p-12 bg-light-100 radius-8">
                                <div class="w-40-px h-40-px bg-orange-100 rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="ri-money-dollar-circle-line text-orange-600 text-xl"></i>
                                </div>
                                <div>
                                    <h6 class="text-md fw-semibold mb-0">Fee Generated</h6>
                                    <span class="text-sm text-secondary-light">When a new fee is created for a student</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center gap-3 p-12 bg-light-100 radius-8">
                                <div class="w-40-px h-40-px bg-purple-100 rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="ri-calendar-check-line text-purple-600 text-xl"></i>
                                </div>
                                <div>
                                    <h6 class="text-md fw-semibold mb-0">Leave Status Update</h6>
                                    <span class="text-sm text-secondary-light">When a leave request is approved/rejected</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center gap-3 p-12 bg-light-100 radius-8">
                                <div class="w-40-px h-40-px bg-indigo-100 rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="ri-file-text-line text-indigo-600 text-xl"></i>
                                </div>
                                <div>
                                    <h6 class="text-md fw-semibold mb-0">Exam Scheduled</h6>
                                    <span class="text-sm text-secondary-light">When a new exam is scheduled for a class</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center gap-3 p-12 bg-light-100 radius-8">
                                <div class="w-40-px h-40-px bg-green-100 rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="ri-bar-chart-line text-green-600 text-xl"></i>
                                </div>
                                <div>
                                    <h6 class="text-md fw-semibold mb-0">Result Published</h6>
                                    <span class="text-sm text-secondary-light">When exam results are published</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center gap-3 p-12 bg-light-100 radius-8">
                                <div class="w-40-px h-40-px bg-red-100 rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="ri-megaphone-line text-red-600 text-xl"></i>
                                </div>
                                <div>
                                    <h6 class="text-md fw-semibold mb-0">Announcements</h6>
                                    <span class="text-sm text-secondary-light">When notes are posted on the board</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center gap-3 p-12 bg-light-100 radius-8">
                                <div class="w-40-px h-40-px bg-teal-100 rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="ri-book-2-line text-teal-600 text-xl"></i>
                                </div>
                                <div>
                                    <h6 class="text-md fw-semibold mb-0">Homework Assigned</h6>
                                    <span class="text-sm text-secondary-light">When new homework is assigned</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.dashboard') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Settings
                </button>
            </div>
        </div>
    </div>
</form>
@endsection
