@extends('layouts.admin')

@section('title', 'Payment Gateways')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Payment Gateways</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Payment Gateways</span>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.settings.gateways.update') }}" method="POST" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <div>
                        <h6 class="text-lg fw-semibold mb-0">Payment Gateways</h6>
                        <p class="text-secondary-light mb-0 small">Activate a single gateway and store its credentials.</p>
                    </div>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-4">
                        <div class="col-md-4">
                            <div class="d-flex align-items-center justify-content-between mb-8">
                                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-0">Cashfree</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" role="switch" name="cashfree_active" value="1" {{ old('cashfree_active', $setting->cashfree_active ?? false) ? 'checked' : '' }}>
                                </div>
                            </div>
                            <label class="text-xs text-secondary-light d-inline-block mb-4">Mode</label>
                            <select name="cashfree_mode" class="form-select mb-8">
                                @php $cashfreeMode = old('cashfree_mode', $setting->cashfree_mode ?? 'sandbox'); @endphp
                                <option value="sandbox" {{ $cashfreeMode === 'sandbox' ? 'selected' : '' }}>Sandbox</option>
                                <option value="production" {{ $cashfreeMode === 'production' ? 'selected' : '' }}>Production</option>
                            </select>
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">App ID</label>
                            <input type="text" name="cashfree_app_id" class="form-control mb-8" value="{{ old('cashfree_app_id', $setting->cashfree_app_id ?? '') }}">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Secret Key</label>
                            <input type="text" name="cashfree_secret_key" class="form-control" value="{{ old('cashfree_secret_key', $setting->cashfree_secret_key ?? '') }}">
                        </div>

                        <div class="col-md-4">
                            <div class="d-flex align-items-center justify-content-between mb-8">
                                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-0">Razorpay</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" role="switch" name="razorpay_active" value="1" {{ old('razorpay_active', $setting->razorpay_active ?? false) ? 'checked' : '' }}>
                                </div>
                            </div>
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Key ID</label>
                            <input type="text" name="razorpay_key_id" class="form-control mb-8" value="{{ old('razorpay_key_id', $setting->razorpay_key_id ?? '') }}">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Key Secret</label>
                            <input type="text" name="razorpay_key_secret" class="form-control" value="{{ old('razorpay_key_secret', $setting->razorpay_key_secret ?? '') }}">
                        </div>

                        <div class="col-md-4">
                            <div class="d-flex align-items-center justify-content-between mb-8">
                                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-0">PhonePe</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" role="switch" name="phonepe_active" value="1" {{ old('phonepe_active', $setting->phonepe_active ?? false) ? 'checked' : '' }}>
                                </div>
                            </div>
                            <label class="text-xs text-secondary-light d-inline-block mb-4">Mode</label>
                            <select name="phonepe_mode" class="form-select mb-8">
                                @php $phonepeMode = old('phonepe_mode', $setting->phonepe_mode ?? 'sandbox'); @endphp
                                <option value="sandbox" {{ $phonepeMode === 'sandbox' ? 'selected' : '' }}>Sandbox</option>
                                <option value="production" {{ $phonepeMode === 'production' ? 'selected' : '' }}>Production</option>
                            </select>
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Merchant ID</label>
                            <input type="text" name="phonepe_merchant_id" class="form-control mb-8" value="{{ old('phonepe_merchant_id', $setting->phonepe_merchant_id ?? '') }}">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Salt Key</label>
                            <input type="text" name="phonepe_salt_key" class="form-control mb-8" value="{{ old('phonepe_salt_key', $setting->phonepe_salt_key ?? '') }}">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Salt Index</label>
                            <input type="text" name="phonepe_salt_index" class="form-control" value="{{ old('phonepe_salt_index', $setting->phonepe_salt_index ?? '') }}">
                        </div>
                    </div>
                    <p class="text-secondary-light small mt-12 mb-0">Only one gateway should be active at a time; clients will use the first active gateway in the order Cashfree → Razorpay → PhonePe.</p>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.dashboard') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Gateways
                </button>
            </div>
        </div>
    </div>
</form>
@endsection



