@extends('layouts.admin')

@section('title', 'Teacher Details')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Teacher Details</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.teacher.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Teacher</a>
            <span class="text-secondary-light">/ Teacher Details</span>
        </div>
    </div>
    <div class="d-flex gap-3">
        <a href="{{ route('admin.teacher.edit', $teacher->id) }}" class="btn btn-primary-600 d-flex align-items-center gap-6">
            <i class="ri-edit-2-line"></i>
            Edit Teacher
        </a>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="row gy-3">
    <!-- Verification Status Card -->
    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Verification Status</h6>
            </div>
            <div class="card-body p-20">
                @if($teacher->isVerified())
                <div class="d-flex align-items-center gap-3 p-16 bg-success-50 border border-success-200 radius-8">
                    <div class="w-48-px h-48-px bg-success-600 rounded-circle d-flex justify-content-center align-items-center">
                        <iconify-icon icon="bitcoin-icons:verify-outline" class="text-white text-xxl"></iconify-icon>
                    </div>
                    <div>
                        <h6 class="text-md fw-semibold mb-2 text-success-600">Verified</h6>
                        <p class="mb-0 text-sm text-secondary-light">Teacher profile has been verified. Documents have been uploaded.</p>
                    </div>
                </div>
                @else
                <div class="d-flex align-items-center gap-3 p-16 bg-danger-50 border border-danger-200 radius-8">
                    <div class="w-48-px h-48-px bg-danger-600 rounded-circle d-flex justify-content-center align-items-center">
                        <iconify-icon icon="ri-error-warning-line" class="text-white text-xxl"></iconify-icon>
                    </div>
                    <div>
                        <h6 class="text-md fw-semibold mb-2 text-danger-600">Not Verified</h6>
                        <p class="mb-0 text-sm text-secondary-light">No documents have been uploaded. Please upload documents to verify this teacher.</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Personal Information -->
    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Personal Information</h6>
            </div>
            <div class="card-body p-20">
                <div class="row gy-3">
                    <div class="col-md-3">
                        @if($teacher->photo)
                        <img src="{{ Storage::url($teacher->photo) }}" alt="{{ $teacher->name }}" class="img-fluid rounded" style="max-width: 200px;">
                        @else
                        <div class="w-200-px h-200-px bg-neutral-200 rounded d-flex justify-content-center align-items-center">
                            <i class="ri-user-line text-4xl text-secondary-light"></i>
                        </div>
                        @endif
                    </div>
                    <div class="col-md-9">
                        <div class="row gy-3">
                            <div class="col-md-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Teacher ID</label>
                                    <p class="text-md fw-medium">{{ $teacher->teacher_id }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Full Name</label>
                                    <p class="text-md fw-medium">{{ $teacher->name }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Email</label>
                                    <p class="text-md fw-medium">{{ $teacher->email }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Phone</label>
                                    <p class="text-md fw-medium">{{ $teacher->phone ?? 'N/A' }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Date of Birth</label>
                                    <p class="text-md fw-medium">{{ $teacher->date_of_birth ? $teacher->date_of_birth->format('d M Y') : 'N/A' }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Gender</label>
                                    <p class="text-md fw-medium">{{ $teacher->gender ?? 'N/A' }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Subjects</label>
                                    <p class="text-md fw-medium">
                                        {{ $teacher->subjects->pluck('name')->join(', ') ?: 'N/A' }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Documents Section -->
    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Documents</h6>
                <a href="{{ route('admin.teacher.edit', $teacher->id) }}" class="btn btn-sm btn-primary-600">
                    <i class="ri-add-line"></i> Add Document
                </a>
            </div>
            <div class="card-body p-20">
                @if($teacher->documents->count() > 0)
                <div class="row gy-3">
                    @foreach($teacher->documents as $document)
                    <div class="col-md-6">
                        <div class="p-16 border radius-8">
                            <div class="d-flex align-items-center justify-content-between gap-20">
                                <div class="d-flex align-items-center gap-12">
                                    <span class="w-48-px h-48-px radius-4 bg-neutral-50 d-flex justify-content-center align-items-center text-xl">
                                        <i class="ri-file-text-line"></i>
                                    </span>
                                    <div>
                                        <span class="text-md fw-medium d-block">{{ $document->document_name }}</span>
                                        <small class="text-secondary-light">{{ strtoupper($document->file_type) }} • {{ number_format($document->file_size / 1024, 2) }} KB</small>
                                    </div>
                                </div>
                                <div class="d-flex gap-2">
                                    <a href="{{ Storage::url($document->file_path) }}" target="_blank" 
                                        class="w-40-px h-40-px radius-4 bg-primary-50 bg-hover-primary-100 text-primary-600 d-flex justify-content-center align-items-center text-xl"
                                        title="Download">
                                        <i class="ri-download-2-line"></i>
                                    </a>
                                    <form action="{{ route('admin.teacher.document.delete', [$teacher->id, $document->id]) }}" method="POST" class="d-inline" 
                                        onsubmit="return confirm('Are you sure you want to delete this document?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                            class="w-40-px h-40-px radius-4 bg-danger-50 bg-hover-danger-100 text-danger-600 d-flex justify-content-center align-items-center text-xl border-0"
                                            title="Delete">
                                            <i class="ri-delete-bin-6-line"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                @else
                <div class="text-center py-40">
                    <i class="ri-file-line text-4xl text-secondary-light mb-3 d-block"></i>
                    <p class="text-secondary-light mb-0">No documents uploaded</p>
                    <a href="{{ route('admin.teacher.edit', $teacher->id) }}" class="btn btn-primary-600 mt-3">
                        <i class="ri-add-line"></i> Upload Documents
                    </a>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

