@extends('layouts.admin')

@section('title', 'Timetable Calendar')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Timetable Calendar (Emergency Changes)</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Timetable Calendar</span>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="mt-24">
    <div class="card h-100">
        <div class="card-body p-20">
            <form class="d-flex flex-wrap align-items-end gap-16 mb-20" method="GET" action="{{ route('admin.timetable-override.index') }}">
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Class</label>
                    <select name="class_id" class="form-control form-select">
                        <option value="">Select Class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}" {{ (int)$classId === $class->id ? 'selected' : '' }}>
                                {{ $class->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Section</label>
                    <select name="section_id" class="form-control form-select">
                        <option value="">Select Section</option>
                        @foreach($sections as $section)
                            <option value="{{ $section->id }}" {{ (int)$sectionId === $section->id ? 'selected' : '' }}>
                                {{ $section->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Teacher</label>
                    <select name="teacher_id" class="form-control form-select">
                        <option value="">All Teachers</option>
                        @foreach($teachers as $teacher)
                            <option value="{{ $teacher->id }}" {{ (int)($teacherId ?? 0) === $teacher->id ? 'selected' : '' }}>
                                {{ $teacher->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Day</label>
                    @php
                        $days = ['' => 'All Days','monday'=>'Monday','tuesday'=>'Tuesday','wednesday'=>'Wednesday','thursday'=>'Thursday','friday'=>'Friday','saturday'=>'Saturday','sunday'=>'Sunday'];
                    @endphp
                    <select name="day" class="form-control form-select">
                        @foreach($days as $key => $label)
                            <option value="{{ $key }}" {{ ($dayFilter ?? '') === $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Room</label>
                    <select name="room" class="form-control form-select">
                        <option value="">All Rooms</option>
                        @foreach($rooms as $room)
                            <option value="{{ $room }}" {{ ($roomFilter ?? '') === $room ? 'selected' : '' }}>
                                {{ $room }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="d-flex gap-10">
                    <button type="submit" class="btn btn-primary-600">
                        Load Timetable
                    </button>
                    <a href="{{ route('admin.timetable-override.index') }}" class="btn btn-outline-secondary">
                        Clear
                    </a>
                </div>
            </form>

            @if($classId && $sectionId && $slots->count())
                @php
                    $dayOrder = ['monday','tuesday','wednesday','thursday','friday','saturday','sunday'];
                    $grouped = $slots->groupBy(function($s) { return strtolower($s->day_of_week); });
                    $activeFilter = $dayFilter ?? '';
                    $filteredDays = collect($dayOrder)->filter(function($day) use ($activeFilter) {
                        return !$activeFilter || $activeFilter === $day;
                    });
                @endphp
                <div class="row g-3">
                    @foreach($filteredDays as $day)
                        @if(isset($grouped[$day]) && $grouped[$day]->count())
                            <div class="col-md-4">
                                <div class="shadow-1 radius-12 bg-base h-100">
                                    <div class="card-header border-bottom bg-base py-12 px-16">
                                        <h6 class="fw-semibold text-primary-light mb-0 text-capitalize">{{ $day }}</h6>
                                    </div>
                                    <div class="card-body p-16">
                                        <div class="table-responsive">
                                            <table class="table table-sm mb-0">
                                                <thead>
                                                    <tr>
                                                        <th style="width: 100px; font-size: 11px;">Time</th>
                                                        <th style="font-size: 11px;">Subject</th>
                                                        <th style="font-size: 11px;">Teacher</th>
                                                        <th style="font-size: 11px;">Room</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($grouped[$day] as $slot)
                                                        @php
                                                            $attrs = $slot->getAttributes();
                                                            $roomName = $attrs['room'] ?? null;
                                                        @endphp
                                                        <tr>
                                                            <td style="font-size: 11px;">{{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }} - {{ \Carbon\Carbon::parse($slot->end_time)->format('h:i A') }}</td>
                                                            <td style="font-size: 11px;">{{ $slot->subject->name ?? '-' }}</td>
                                                            <td style="font-size: 11px;">{{ $slot->teacher->name ?? '-' }}</td>
                                                            <td style="font-size: 11px;">{{ $roomName ?: '-' }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @elseif(!$activeFilter)
                            <div class="col-md-4">
                                <div class="shadow-1 radius-12 bg-base h-100">
                                    <div class="card-header border-bottom bg-base py-12 px-16">
                                        <h6 class="fw-semibold text-primary-light mb-0 text-capitalize">{{ $day }}</h6>
                                    </div>
                                    <div class="card-body p-16">
                                        <p class="text-secondary-light text-sm mb-0">No classes scheduled</p>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            @elseif($classId && $sectionId)
                <p class="mb-0 text-secondary-light">No timetable slots found for this class & section.</p>
            @else
                <p class="mb-0 text-secondary-light">Select class and section, then click "Load Timetable" to view the weekly schedule.</p>
            @endif
        </div>
    </div>
</div>
@endsection
