@extends('layouts.admin')

@section('title', 'Edit Timetable Slot')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Timetable Slot</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.timetable.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Timetable</a>
            <span class="text-secondary-light">/ Edit Slot</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.timetable.update', $timetable->id) }}" method="POST" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Timetable Slot</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="class_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Class <span class="text-danger-600">*</span>
                                </label>
                                <select id="class_id" name="class_id" class="form-control form-select @error('class_id') is-invalid @enderror" required>
                                    <option value="">Select Class</option>
                                    @foreach($classes as $class)
                                    <option value="{{ $class->id }}" {{ old('class_id', $timetable->class_id) == $class->id ? 'selected' : '' }}>
                                        {{ $class->name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('class_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="section_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Section <span class="text-danger-600">*</span>
                                </label>
                                <select id="section_id" name="section_id" class="form-control form-select @error('section_id') is-invalid @enderror" required>
                                    <option value="">Select Section</option>
                                    @foreach($sections as $section)
                                    <option value="{{ $section->id }}" {{ old('section_id', $timetable->section_id) == $section->id ? 'selected' : '' }}>
                                        {{ $section->name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('section_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="day_of_week" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Day <span class="text-danger-600">*</span>
                                </label>
                                <select id="day_of_week" name="day_of_week" class="form-control form-select @error('day_of_week') is-invalid @enderror" required>
                                    <option value="">Select Day</option>
                                    @foreach($days as $d)
                                    <option value="{{ $d }}" {{ old('day_of_week', $timetable->day_of_week) == $d ? 'selected' : '' }}>
                                        {{ ucfirst($d) }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('day_of_week')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="subject_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Subject <span class="text-danger-600">*</span>
                                </label>
                                <select id="subject_id" name="subject_id" class="form-control form-select @error('subject_id') is-invalid @enderror" required>
                                    <option value="">Select Subject</option>
                                    @foreach($subjects as $subject)
                                    <option value="{{ $subject->id }}" {{ old('subject_id', $timetable->subject_id) == $subject->id ? 'selected' : '' }}>
                                        {{ $subject->name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('subject_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="teacher_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Teacher <span class="text-danger-600">*</span>
                                </label>
                                <select id="teacher_id" name="teacher_id" class="form-control form-select @error('teacher_id') is-invalid @enderror" required>
                                    <option value="">Select Teacher</option>
                                    @foreach($teachers as $teacher)
                                    <option value="{{ $teacher->id }}"
                                        data-subjects="{{ $teacher->subjects->pluck('id')->join(',') }}"
                                        {{ old('teacher_id', $timetable->teacher_id) == $teacher->id ? 'selected' : '' }}>
                                        {{ $teacher->name }}
                                    </option>
                                    @endforeach
                                </select>
                                <small class="text-secondary-light d-block">Teachers filtered by selected subject</small>
                                @error('teacher_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                @error('teacher_id_conflict')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="start_time" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Start Time <span class="text-danger-600">*</span>
                                </label>
                                <input type="time" class="form-control @error('start_time') is-invalid @enderror" 
                                    id="start_time" name="start_time" value="{{ old('start_time', \Carbon\Carbon::parse($timetable->start_time)->format('H:i')) }}" required>
                                @error('start_time')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-secondary-light">Format: 07:00 AM</small>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="end_time" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    End Time <span class="text-danger-600">*</span>
                                </label>
                                <input type="time" class="form-control @error('end_time') is-invalid @enderror" 
                                    id="end_time" name="end_time" value="{{ old('end_time', \Carbon\Carbon::parse($timetable->end_time)->format('H:i')) }}" required>
                                @error('end_time')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-secondary-light">Format: 08:00 AM</small>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="room_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Room
                                </label>
                                <select id="room_id" name="room_id" class="form-control form-select @error('room_id') is-invalid @enderror">
                                    <option value="">Select Room</option>
                                    @foreach($rooms as $room)
                                    <option value="{{ $room->id }}" {{ old('room_id') == $room->id ? 'selected' : ($timetable->room === $room->name ? 'selected' : '') }}>
                                        {{ $room->name }}@if($room->capacity) ({{ $room->capacity }})@endif
                                    </option>
                                    @endforeach
                                </select>
                                @error('room_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.timetable.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Update Slot
                </button>
            </div>
        </div>
    </div>
</form>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const subjectSelect = document.getElementById('subject_id');
        const teacherSelect = document.getElementById('teacher_id');

        function filterTeachers() {
            if (!subjectSelect || !teacherSelect) return;
            const selectedSubject = subjectSelect.value;
            Array.from(teacherSelect.options).forEach(opt => {
                if (!opt.value) return; // skip placeholder
                const subjects = (opt.dataset.subjects || '').split(',').filter(Boolean);
                const match = !selectedSubject || subjects.includes(selectedSubject);
                opt.style.display = match ? '' : 'none';
            });
            // If current selection is hidden, clear it
            const current = teacherSelect.selectedOptions[0];
            if (current && current.style.display === 'none') {
                teacherSelect.value = '';
            }
        }

        if (subjectSelect) {
            subjectSelect.addEventListener('change', filterTeachers);
            filterTeachers();
        }
    });
</script>
@endsection


