@extends('layouts.admin')

@section('title', 'Timetable')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Timetable</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Timetable</span>
        </div>
    </div>
    <a href="{{ route('admin.timetable.create') }}" class="btn btn-primary-600 d-flex align-items-center gap-6">
        <span class="d-flex text-md">
            <i class="ri-add-large-line"></i>
        </span>
        Add Timetable Slot
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="mt-24">
    <div class="card h-100">
        <div class="card-body p-0 dataTable-wrapper">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-16 px-20 py-12 border-bottom border-neutral-200">
                <form class="d-flex flex-wrap align-items-center gap-16" method="GET" action="{{ route('admin.timetable.index') }}">
                    <div class="d-flex align-items-center gap-8">
                        <label class="text-sm fw-semibold text-primary-light mb-0">Class</label>
                        <select name="class_id" class="form-control form-select">
                            <option value="">All</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->id }}" {{ $classId == $class->id ? 'selected' : '' }}>
                                    {{ $class->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="d-flex align-items-center gap-8">
                        <label class="text-sm fw-semibold text-primary-light mb-0">Section</label>
                        <select name="section_id" class="form-control form-select">
                            <option value="">All</option>
                            @foreach($sections as $section)
                                <option value="{{ $section->id }}" {{ $sectionId == $section->id ? 'selected' : '' }}>
                                    {{ $section->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="d-flex align-items-center gap-8">
                        <label class="text-sm fw-semibold text-primary-light mb-0">Day</label>
                        <select name="day" class="form-control form-select">
                            <option value="">All</option>
                            @foreach($days as $d)
                                <option value="{{ $d }}" {{ $day == $d ? 'selected' : '' }}>
                                    {{ ucfirst($d) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary-600">
                        Filter
                    </button>
                </form>
            </div>

            <div class="p-0">
                <table class="table bordered-table mb-0 data-table" id="dataTable" data-page-length='20'>
                    <thead>
                        <tr>
                            <th scope="col">S.L</th>
                            <th scope="col">Time</th>
                            <th scope="col">Day</th>
                            <th scope="col">Class</th>
                            <th scope="col">Section</th>
                            <th scope="col">Subject</th>
                            <th scope="col">Teacher</th>
                            <th scope="col">Room</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($timetables as $index => $slot)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>
                                {{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }}
                                -
                                {{ \Carbon\Carbon::parse($slot->end_time)->format('h:i A') }}
                            </td>
                            <td>{{ ucfirst($slot->day_of_week) }}</td>
                            <td>{{ $slot->schoolClass ? $slot->schoolClass->name : 'N/A' }}</td>
                            <td>{{ $slot->section ? $slot->section->name : 'N/A' }}</td>
                            <td>{{ $slot->subject ? $slot->subject->name : 'N/A' }}</td>
                            <td>{{ $slot->teacher ? $slot->teacher->name : 'N/A' }}</td>
                            <td>{{ $slot->room ?? 'N/A' }}</td>
                            <td>
                                <div class="d-flex flex-wrap gap-2">
                                    <a href="{{ route('admin.timetable.edit', $slot->id) }}" 
                                        class="btn btn-sm btn-primary-600 d-flex align-items-center justify-content-center" 
                                        style="width: 32px; height: 32px; padding: 0;"
                                        title="Edit">
                                        <i class="ri-pencil-line"></i>
                                    </a>
                                    <form action="{{ route('admin.timetable.destroy', $slot->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                            class="btn btn-sm btn-danger-600 d-flex align-items-center justify-content-center"
                                            style="width: 32px; height: 32px; padding: 0;"
                                            onclick="return confirm('Are you sure you want to delete this slot?');"
                                            title="Delete">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center">No timetable slots found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection


