<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="description" content="Tuition Center Management System - Teacher Portal">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>@yield('title', 'Teacher') - Tuition Management System</title>
  <link rel="icon" type="image/png" href="{{ asset('assets/images/favicon.png') }}" sizes="16x16">
  <!-- remix icon font css  -->
  <link rel="stylesheet" href="{{ asset('assets/css/remixicon.css') }}">
  <!-- BootStrap css -->
  <link rel="stylesheet" href="{{ asset('assets/css/lib/bootstrap.min.css') }}">
  <!-- main css -->
  <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
  <style>
    html, body {
      margin: 0 !important;
      padding: 0 !important;
      overflow-x: hidden !important;
    }
    
    .sidebar {
      position: fixed !important;
      left: 0 !important;
      top: 0 !important;
      z-index: 999 !important;
      height: 100vh !important;
      width: 15.625rem !important;
    }
    
    @media (min-width: 1200px) {
      .sidebar {
        width: 13.75rem !important;
      }
    }
    
    @media (min-width: 1400px) {
      .sidebar {
        width: 17.1875rem !important;
      }
    }
    
    @media (min-width: 1650px) {
      .sidebar {
        width: 19.5rem !important;
      }
    }
    
    .dashboard-main {
      margin-left: 0 !important;
      margin-inline-start: 0 !important;
      width: 100% !important;
    }
    
    @media (min-width: 1200px) {
      .dashboard-main {
        margin-left: 13.75rem !important;
        margin-inline-start: 13.75rem !important;
        width: calc(100% - 13.75rem) !important;
        max-width: calc(100% - 13.75rem) !important;
      }
    }
    
    @media (min-width: 1400px) {
      .dashboard-main {
        margin-left: 17.1875rem !important;
        margin-inline-start: 17.1875rem !important;
        width: calc(100% - 17.1875rem) !important;
        max-width: calc(100% - 17.1875rem) !important;
      }
    }
    
    @media (min-width: 1650px) {
      .dashboard-main {
        margin-left: 19.5rem !important;
        margin-inline-start: 19.5rem !important;
        width: calc(100% - 19.5rem) !important;
        max-width: calc(100% - 19.5rem) !important;
      }
    }
    
    .dashboard-main-body {
      width: 100% !important;
      max-width: 100% !important;
      overflow-x: hidden !important;
    }
  </style>
</head>

<body>
  @include('partials.teacher.sidebar')

  <main class="dashboard-main">
    @include('partials.teacher.topbar')

    <div class="dashboard-main-body">
      @yield('content')
    </div>
  </main>

  <script src="{{ asset('assets/js/lib/jquery-3.7.1.min.js') }}"></script>
  <script src="{{ asset('assets/js/lib/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('assets/js/app.js') }}"></script>
  @yield('scripts')
</body>

</html>



