@extends('layouts.parent')

@section('title', 'Parent Dashboard')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Parent Dashboard</h1>
        <span class="text-secondary-light">Welcome, {{ $user->name }}</span>
    </div>
</div>

@if(isset($topMarksAchievements) && $topMarksAchievements->count() > 0)
    @foreach($topMarksAchievements as $achievement)
        <div class="alert alert-success alert-dismissible fade show shadow-1 radius-12 border border-success-200 mb-16" role="alert">
            <div class="d-flex align-items-center gap-12">
                <div class="flex-shrink-0">
                    <div class="w-48-px h-48-px bg-success-100 rounded-circle d-flex align-items-center justify-content-center">
                        <i class="ri-trophy-line text-success-600 text-xl"></i>
                    </div>
                </div>
                <div class="flex-grow-1">
                    <h6 class="fw-semibold mb-1 text-success-700">
                        🎉 Congratulations! {{ $achievement['student']->name }} achieved Top {{ $achievement['rank'] }} in {{ $achievement['examSchedule']->examType->name ?? 'Exam' }}!
                    </h6>
                    <p class="mb-0 text-sm text-success-600">
                        <strong>{{ $achievement['examSchedule']->subject->name ?? 'Subject' }}</strong> - 
                        Marks: <strong>{{ $achievement['marks'] }}/{{ $achievement['maxMarks'] }}</strong> 
                        ({{ $achievement['percentage'] }}%) | 
                        Date: {{ $achievement['examSchedule']->exam_date->format('d M Y') }}
                    </p>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        </div>
    @endforeach
@endif

<!-- Stats Cards -->
<div class="row gy-3 mb-24">
    <div class="col-xl-3 col-md-6">
        <div class="shadow-1 radius-12 bg-base p-16 h-100">
            <p class="text-secondary-light text-sm mb-4">Children</p>
            <h3 class="h4 fw-semibold mb-2">{{ $childCount }}</h3>
            <p class="mb-0 text-secondary-light text-sm">Linked to your account</p>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="shadow-1 radius-12 bg-base p-16 h-100">
            <p class="text-secondary-light text-sm mb-4">Total Fees</p>
            <h3 class="h4 fw-semibold mb-2">₹{{ number_format($totalAmount, 2) }}</h3>
            <p class="mb-0 text-secondary-light text-sm">All assigned fees</p>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="shadow-1 radius-12 bg-base p-16 h-100">
            <p class="text-secondary-light text-sm mb-4">Paid</p>
            <h3 class="h4 fw-semibold mb-2 text-success">₹{{ number_format($totalPaid, 2) }}</h3>
            <p class="mb-0 text-secondary-light text-sm">Payments completed</p>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="shadow-1 radius-12 bg-base p-16 h-100">
            <p class="text-secondary-light text-sm mb-4">Due</p>
            <div class="d-flex align-items-center justify-content-between">
                <h3 class="h4 fw-semibold mb-2 text-danger">₹{{ number_format($totalDue, 2) }}</h3>
                <span class="badge bg-warning-subtle text-warning">{{ $pendingCount }} pending</span>
            </div>
            <p class="mb-0 text-secondary-light text-sm">Pending balance</p>
        </div>
    </div>
</div>

<!-- Children Cards with Attendance -->
@if($children && $children->count())
<div class="row gy-3 mb-24">
    @foreach($children as $student)
        @php
            $photo = $student->photo ? asset('storage/'.$student->photo) : asset('assets/images/users/user1.png');
            $attendance = $attendanceStats[$student->id] ?? ['present' => 0, 'absent' => 0, 'late' => 0, 'leave' => 0, 'total' => 0, 'percentage' => 0];
        @endphp
        <div class="col-12 col-lg-6">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <div class="d-flex align-items-center gap-12">
                        <img src="{{ $photo }}" alt="{{ $student->name }}" class="rounded-circle object-fit-cover" style="width: 60px; height: 60px;">
                        <div class="flex-grow-1">
                            <h6 class="fw-semibold mb-1 text-primary-light">{{ $student->name }}</h6>
                            <p class="mb-0 text-sm text-secondary-light">
                                {{ $student->schoolClass->name ?? '-' }} @if($student->section) ({{ $student->section->name }})@endif
                            </p>
                        </div>
                        <div class="d-flex gap-2">
                            <a href="{{ route('parent.attendance.index', ['student_id' => $student->id]) }}" class="btn btn-sm btn-outline-primary">
                                View Attendance
                            </a>
                            <a href="{{ route('parent.students.show', $student->id) }}" class="btn btn-sm btn-outline-secondary">
                                View Details
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body p-20">
                    <!-- Attendance Stats -->
                    <div class="mb-16">
                        <h6 class="fw-semibold mb-12 text-primary-light">Attendance (This Month)</h6>
                        <div class="row g-2 mb-12">
                            <div class="col-6">
                                <div class="bg-success-50 p-12 radius-8 text-center">
                                    <p class="mb-0 text-sm text-secondary-light">Present</p>
                                    <h5 class="mb-0 fw-bold text-success">{{ $attendance['present'] }}</h5>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="bg-danger-50 p-12 radius-8 text-center">
                                    <p class="mb-0 text-sm text-secondary-light">Absent</p>
                                    <h5 class="mb-0 fw-bold text-danger">{{ $attendance['absent'] }}</h5>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-center justify-content-between">
                            <span class="text-sm text-secondary-light">Attendance Rate:</span>
                            <span class="fw-semibold text-primary-600">{{ $attendance['percentage'] }}%</span>
                        </div>
                        <div class="progress mt-2" style="height: 8px;">
                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $attendance['percentage'] }}%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>
@endif

<!-- Timetable Section -->
@if($children && $children->count())
<div class="row gy-3 mb-24">
    @foreach($children as $student)
        @php
            $todaySlots = $todayTimetable[$student->id] ?? collect();
            $tomorrowSlots = $tomorrowTimetable[$student->id] ?? collect();
        @endphp
        <div class="col-12 col-lg-6">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">{{ $student->name }} - Today's Timetable</h6>
                    <span class="text-sm text-secondary-light">{{ \Carbon\Carbon::now()->format('d M Y') }}</span>
                </div>
                <div class="card-body p-20">
                    @if($todaySlots->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th>Time</th>
                                        <th>Subject</th>
                                        <th>Teacher</th>
                                        <th>Room</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($todaySlots as $slot)
                                        <tr>
                                            <td>
                                                {{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }} - 
                                                {{ \Carbon\Carbon::parse($slot->end_time)->format('h:i A') }}
                                            </td>
                                            <td>{{ $slot->subject->name ?? '-' }}</td>
                                            <td>{{ $slot->teacher->name ?? '-' }}</td>
                                            <td>{{ $slot->room ?? ($slot->roomRelation ? $slot->roomRelation->name : '-') }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="mb-0 text-secondary-light text-center py-12">No classes scheduled for today.</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24">
                    <h6 class="text-lg fw-semibold mb-0">{{ $student->name }} - Tomorrow's Timetable</h6>
                    <span class="text-sm text-secondary-light">{{ \Carbon\Carbon::now()->addDay()->format('d M Y') }}</span>
                </div>
                <div class="card-body p-20">
                    @if($tomorrowSlots->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th>Time</th>
                                        <th>Subject</th>
                                        <th>Teacher</th>
                                        <th>Room</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($tomorrowSlots as $slot)
                                        <tr>
                                            <td>
                                                {{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }} - 
                                                {{ \Carbon\Carbon::parse($slot->end_time)->format('h:i A') }}
                                            </td>
                                            <td>{{ $slot->subject->name ?? '-' }}</td>
                                            <td>{{ $slot->teacher->name ?? '-' }}</td>
                                            <td>{{ $slot->room ?? ($slot->roomRelation ? $slot->roomRelation->name : '-') }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="mb-0 text-secondary-light text-center py-12">No classes scheduled for tomorrow.</p>
                    @endif
                </div>
            </div>
        </div>
    @endforeach
</div>
@endif

<!-- Upcoming Exams and Recent Results -->
<div class="row gy-3">
    <div class="col-12 col-xl-6">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Upcoming Exams</h6>
                <span class="text-secondary-light text-sm">Next 30 days</span>
            </div>
            <div class="card-body p-20">
                @if(isset($upcomingExams) && $upcomingExams->count())
                    <div class="table-responsive">
                        <table class="table table-sm align-middle mb-0">
                            <thead>
                                <tr>
                                    <th>Exam</th>
                                    <th>Subject</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($upcomingExams->take(5) as $exam)
                                    <tr>
                                        <td>{{ $exam->examType->name ?? '-' }}</td>
                                        <td>{{ $exam->subject->name ?? '-' }}</td>
                                        <td>{{ $exam->exam_date ? $exam->exam_date->format('d M Y') : '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @if($upcomingExams->count() > 5)
                        <div class="text-center mt-12">
                            <a href="{{ route('parent.exams.index') }}" class="text-primary-600 text-sm hover-underline">View all exams</a>
                        </div>
                    @endif
                @else
                    <p class="mb-0 text-secondary-light">No upcoming exams scheduled.</p>
                @endif
            </div>
        </div>
    </div>
    <div class="col-12 col-xl-6">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Recent Exam Results</h6>
                <a href="{{ route('parent.exams.index') }}" class="text-secondary-light text-sm hover-text-primary hover-underline">
                    View all
                </a>
            </div>
            <div class="card-body p-20">
                @if(isset($recentResults) && $recentResults->count())
                    <div class="table-responsive">
                        <table class="table table-sm align-middle mb-0">
                            <thead>
                                <tr>
                                    <th>Student</th>
                                    <th>Exam</th>
                                    <th>Subject</th>
                                    <th>Marks</th>
                                    <th>Grade</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recentResults->take(5) as $result)
                                    @php
                                        $schedule = $result->examSchedule;
                                        $student = $result->student;
                                    @endphp
                                    <tr>
                                        <td class="text-sm">{{ $student->name }}</td>
                                        <td class="text-sm">{{ $schedule->examType->name ?? '-' }}</td>
                                        <td class="text-sm">{{ $schedule->subject->name ?? '-' }}</td>
                                        <td class="text-sm">
                                            {{ $result->marks_obtained ?? '-' }}
                                            @if($schedule->max_marks)
                                                / {{ $schedule->max_marks }}
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-primary-subtle text-primary">{{ $result->grade ?? '-' }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="mb-0 text-secondary-light">No exam results available yet.</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
