@extends('layouts.parent')

@section('title', 'Fees Details')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Fees Details</h1>
        <span class="text-secondary-light">All fee payments for your children</span>
    </div>
</div>

<div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
    <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
        <div>
            <h6 class="text-lg fw-semibold mb-0">Payment History</h6>
            <p class="text-secondary-light mb-0 text-sm">Paid and pending fees for your children</p>
        </div>
    </div>
    <div class="card-body p-20">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        @if($collections->count())
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Student</th>
                            <th>Fees Type</th>
                            <th class="text-end">Amount</th>
                            <th class="text-end">Paid</th>
                            <th class="text-end">Due</th>
                            <th>Method</th>
                            <th>Reference</th>
                            <th class="text-end">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($collections as $c)
                        @php
                            $due = max(0, ($c->amount ?? 0) - ($c->paid_amount ?? 0));
                        @endphp
                        <tr>
                            <td>
                                @if($c->payment_date)
                                    {{ \Carbon\Carbon::parse($c->payment_date)->format('d M Y') }}
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                <div class="d-flex flex-column">
                                    <span class="fw-semibold text-primary-light">{{ $c->student->name ?? '-' }}</span>
                                    <span class="text-secondary-light text-xs">{{ $c->student->admission_no ?? '-' }}</span>
                                </div>
                            </td>
                            <td>{{ $c->feesType->name ?? '-' }}</td>
                            <td class="text-end">{{ number_format($c->amount, 2) }}</td>
                            <td class="text-end text-success fw-semibold">{{ number_format($c->paid_amount, 2) }}</td>
                            <td class="text-end {{ $due > 0 ? 'text-danger' : 'text-secondary-light' }}">{{ number_format($due, 2) }}</td>
                            <td>{{ $c->payment_method ?? '-' }}</td>
                            <td>{{ $c->reference ?? '-' }}</td>
                            <td class="text-end">
                                @if($due > 0)
                                    <form action="{{ route('parent.fees.pay', $c->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-xs btn-primary-600 px-12 py-6">Pay ₹{{ number_format($due, 2) }}</button>
                                    </form>
                                @else
                                    <div class="d-inline-flex gap-2 align-items-center justify-content-end">
                                        <span class="badge bg-success-subtle text-success">Paid</span>
                                        <a href="{{ route('parent.fees.receipt', $c->id) }}" class="btn btn-xs btn-outline-primary px-12 py-6">
                                            Receipt
                                        </a>
                                    </div>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <p class="mb-0 text-secondary-light">No fees payments found yet.</p>
        @endif
    </div>
</div>
@endsection



