@extends('layouts.parent')

@section('title', 'Fees Receipt')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Fees Receipt</h1>
        <div class="text-secondary-light">
            Receipt for {{ $collection->student->name ?? 'Student' }}
        </div>
    </div>
    <div class="d-flex gap-2">
        <button class="btn btn-outline-primary" onclick="window.print()">
            <i class="ri-download-line me-1"></i> Download / Print
        </button>
    </div>
</div>

<div class="receipt-a5 bg-white shadow-1 radius-12 p-24 mx-auto">
    <div class="d-flex justify-content-between align-items-center mb-16 border-bottom pb-12">
        <div>
            <h2 class="h6 fw-semibold mb-4">{{ $collection->student->schoolClass->name ?? 'Tuition Center' }}</h2>
            <p class="mb-0 text-secondary-light text-sm">Fees Receipt</p>
        </div>
        <div class="text-end text-sm">
            <div><strong>Receipt No:</strong> {{ $collection->id }}</div>
            <div><strong>Date:</strong> {{ $collection->payment_date ? \Carbon\Carbon::parse($collection->payment_date)->format('d M Y') : '-' }}</div>
        </div>
    </div>

    <div class="row mb-16">
        <div class="col-6 text-sm">
            <p class="mb-1"><strong>Student Name:</strong> {{ $collection->student->name ?? '-' }}</p>
            <p class="mb-1"><strong>Admission No:</strong> {{ $collection->student->admission_no ?? '-' }}</p>
            <p class="mb-1"><strong>Class / Section:</strong> 
                {{ $collection->student->schoolClass->name ?? '-' }} 
                @if($collection->student && $collection->student->section)/ {{ $collection->student->section->name }}@endif
            </p>
        </div>
        <div class="col-6 text-sm">
            <p class="mb-1"><strong>Fees Type:</strong> {{ $collection->feesType->name ?? '-' }}</p>
            <p class="mb-1"><strong>Method:</strong> {{ $collection->payment_method ?? '-' }}</p>
            <p class="mb-1"><strong>Reference:</strong> {{ $collection->reference ?? '-' }}</p>
        </div>
    </div>

    <table class="table table-sm mb-16">
        <thead>
            <tr>
                <th>Description</th>
                <th class="text-end">Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>{{ $collection->feesType->name ?? 'Fees' }}</td>
                <td class="text-end">{{ number_format($collection->amount, 2) }}</td>
            </tr>
            @if(($collection->discount_amount ?? 0) > 0)
            <tr>
                <td>Discount</td>
                <td class="text-end">- {{ number_format($collection->discount_amount, 2) }}</td>
            </tr>
            @endif
        </tbody>
        <tfoot>
            <tr>
                <th>Total Paid</th>
                <th class="text-end">{{ number_format($collection->paid_amount, 2) }}</th>
            </tr>
        </tfoot>
    </table>

    @if($collection->notes)
    <p class="text-sm"><strong>Notes:</strong> {{ $collection->notes }}</p>
    @endif

    <div class="d-flex justify-content-between mt-24 text-sm">
        <div>
            <p class="mb-0">__________________________</p>
            <p class="mb-0">Student / Parent Signature</p>
        </div>
        <div class="text-end">
            <p class="mb-0">__________________________</p>
            <p class="mb-0">Authorized Signature</p>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<style>
@media print {
    body * {
        visibility: hidden;
    }
    .receipt-a5, .receipt-a5 * {
        visibility: visible;
    }
    body {
        margin: 0;
    }
    .receipt-a5 {
        position: relative;
        width: auto;
        min-height: 148mm;
        margin: 0 auto;
        padding: 12mm 16mm;
        box-sizing: border-box;
        box-shadow: none !important;
        border: 1px solid #ddd;
    }
    .receipt-a5 table {
        width: 100%;
    }
}
</style>
@endsection


