@extends('layouts.parent')

@section('title', 'Homework Details')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Assignment Details</h1>
        <span class="text-secondary-light">View assignment details</span>
    </div>
    <a href="{{ route('parent.homework.index') }}" class="btn btn-outline-primary">← Back to Assignment</a>
</div>

<div class="row gy-3">
    <div class="col-lg-8">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24">
                <h6 class="text-lg fw-semibold mb-0">{{ $homework->title }}</h6>
            </div>
            <div class="card-body p-20">
                <div class="mb-16">
                    <h6 class="fw-semibold mb-8 text-primary-light">Description</h6>
                    <p class="text-secondary-light">{{ $homework->description ?? 'No description provided.' }}</p>
                </div>
                
                @if($homework->notes)
                <div class="mb-16">
                    <h6 class="fw-semibold mb-8 text-primary-light">Notes</h6>
                    <p class="text-secondary-light">{{ $homework->notes }}</p>
                </div>
                @endif

                @if($homework->attachments && count($homework->attachments) > 0)
                <div>
                    <h6 class="fw-semibold mb-8 text-primary-light">Attachments</h6>
                    <div class="d-flex flex-wrap gap-2">
                        @foreach($homework->attachments as $attachment)
                        <a href="{{ asset('storage/'.$attachment) }}" target="_blank" class="badge bg-primary-subtle text-primary p-3 text-decoration-none d-flex align-items-center gap-2">
                            <i class="ri-file-line"></i> {{ basename($attachment) }}
                        </a>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24">
                <h6 class="text-lg fw-semibold mb-0">Details</h6>
            </div>
            <div class="card-body p-20">
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Teacher</p>
                    <p class="fw-semibold mb-0">{{ $homework->teacher->name ?? '-' }}</p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Class / Section</p>
                    <p class="fw-semibold mb-0">
                        {{ $homework->schoolClass->name ?? '-' }}
                        @if($homework->section)
                            / {{ $homework->section->name }}
                        @endif
                    </p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Subject</p>
                    <p class="fw-semibold mb-0">{{ $homework->subject->name ?? '-' }}</p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Assigned Date</p>
                    <p class="fw-semibold mb-0">{{ $homework->assigned_date->format('d M Y') }}</p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Due Date</p>
                    <p class="fw-semibold mb-0">
                        {{ $homework->due_date->format('d M Y') }}
                        @if($homework->due_date->isPast())
                            <span class="badge bg-danger-subtle text-danger ms-2">Overdue</span>
                        @elseif($homework->due_date->isToday())
                            <span class="badge bg-warning-subtle text-warning ms-2">Due Today</span>
                        @endif
                    </p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Status</p>
                    @php
                        $statusClass = 'bg-secondary-subtle text-secondary';
                        if($homework->status === 'active') $statusClass = 'bg-success-subtle text-success';
                        elseif($homework->status === 'completed') $statusClass = 'bg-primary-subtle text-primary';
                        elseif($homework->status === 'cancelled') $statusClass = 'bg-danger-subtle text-danger';
                    @endphp
                    <span class="badge {{ $statusClass }}">{{ ucfirst($homework->status) }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Submission Section -->
@if($children->count() > 0)
<div class="row gy-3 mt-3">
    <div class="col-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24">
                <h6 class="text-lg fw-semibold mb-0">Submit Assignment</h6>
            </div>
            <div class="card-body p-20">
                @if($children->count() > 1)
                    <div class="mb-16">
                        <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Select Child</label>
                        <select id="submission_student_id" class="form-select">
                            <option value="">-- Select Child --</option>
                            @foreach($children as $child)
                                @if($homework->class_id == $child->class_id && (!$homework->section_id || $homework->section_id == $child->section_id))
                                    <option value="{{ $child->id }}">{{ $child->name }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                @else
                    @php
                        $eligibleChild = $children->firstWhere(function($child) use ($homework) {
                            return $homework->class_id == $child->class_id && (!$homework->section_id || $homework->section_id == $child->section_id);
                        });
                    @endphp
                    @if($eligibleChild)
                        <input type="hidden" id="submission_student_id" value="{{ $eligibleChild->id }}">
                    @endif
                @endif

                @php
                    $eligibleChildren = $children->filter(function($child) use ($homework) {
                        return $homework->class_id == $child->class_id && (!$homework->section_id || $homework->section_id == $child->section_id);
                    });
                @endphp

                @if($eligibleChildren->count() > 0)
                    @foreach($eligibleChildren as $child)
                        @php
                            $submission = isset($submissions) && isset($submissions[$child->id]) ? $submissions[$child->id] : null;
                        @endphp
                        <div class="submission-section mb-20" data-student-id="{{ $child->id }}" style="{{ $children->count() > 1 ? 'display: none;' : '' }}">
                            <h6 class="fw-semibold mb-12 text-primary-light">{{ $child->name }} - Submission Status</h6>
                            
                            @if($submission)
                                <div class="alert alert-info mb-16">
                                    <div class="d-flex align-items-center justify-content-between mb-2">
                                        <strong>
                                            @if($submission->status === 'late')
                                                <span class="badge bg-danger-subtle text-danger">Late Submit</span>
                                            @else
                                                <span class="badge bg-success-subtle text-success">Submitted</span>
                                            @endif
                                        </strong>
                                        <span class="text-sm text-secondary-light">Submitted on: {{ $submission->submitted_date->format('d M Y') }}</span>
                                    </div>
                                    @if($submission->submission_notes)
                                        <p class="mb-2"><strong>Your Notes:</strong> {{ $submission->submission_notes }}</p>
                                    @endif
                                    @if($submission->grade)
                                        <div class="mb-2">
                                            <strong>Grade:</strong> 
                                            <span class="badge bg-primary-subtle text-primary">{{ $submission->grade }}</span>
                                        </div>
                                    @endif
                                    @if($submission->teacher_notes)
                                        <div class="mb-2 p-2 bg-light rounded">
                                            <strong>Teacher Notes:</strong>
                                            <p class="mb-0 mt-1">{{ $submission->teacher_notes }}</p>
                                        </div>
                                    @endif
                                    @if($submission->attachments && count($submission->attachments) > 0)
                                        <div class="mt-2">
                                            <strong>Attachments:</strong>
                                            <div class="d-flex flex-wrap gap-2 mt-2">
                                                @foreach($submission->attachments as $attachment)
                                                <a href="{{ asset('storage/'.$attachment) }}" target="_blank" class="badge bg-primary-subtle text-primary p-2 text-decoration-none">
                                                    <i class="ri-file-line"></i> {{ basename($attachment) }}
                                                </a>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @else
                                <div class="alert alert-warning mb-16">
                                    <strong>Not Submitted</strong>
                                </div>
                            @endif

                            <form action="{{ route('parent.homework.submit', $homework->id) }}" method="POST" enctype="multipart/form-data" class="submission-form">
                                @csrf
                                <input type="hidden" name="student_id" value="{{ $child->id }}">
                                
                                <div class="row gy-3">
                                    <div class="col-md-6">
                                        <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                            Submission Date <span class="text-danger-600">*</span>
                                        </label>
                                        <input type="date" name="submitted_date" class="form-control" required value="{{ old('submitted_date', now()->toDateString()) }}">
                                    </div>
                                    <div class="col-12">
                                        <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                            Submission Notes
                                        </label>
                                        <textarea name="submission_notes" rows="3" class="form-control" placeholder="Add any notes about your submission">{{ old('submission_notes') }}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                            Attachments
                                        </label>
                                        <input type="file" name="attachments[]" class="form-control" multiple accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                                        <small class="text-secondary-light">You can select multiple files (PDF, DOC, DOCX, JPG, PNG). Max 10MB per file.</small>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary-600">
                                            {{ $submission ? 'Update Submission' : 'Submit Assignment' }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    @endforeach
                @else
                    <p class="text-secondary-light">No eligible children for this homework assignment.</p>
                @endif
            </div>
        </div>
    </div>
</div>

@if($children->count() > 1)
@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const studentSelect = document.getElementById('submission_student_id');
        const submissionSections = document.querySelectorAll('.submission-section');
        
        studentSelect.addEventListener('change', function() {
            const selectedStudentId = this.value;
            submissionSections.forEach(section => {
                if (section.dataset.studentId === selectedStudentId) {
                    section.style.display = 'block';
                } else {
                    section.style.display = 'none';
                }
            });
        });
    });
</script>
@endsection
@endif
@endif
@endsection
