@extends('layouts.parent')

@section('title', 'Notifications')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Notifications</h1>
        <span class="text-secondary-light">View all your notifications</span>
    </div>
    <form action="{{ route('parent.notifications.mark-all-read') }}" method="POST" class="d-inline">
        @csrf
        <button type="submit" class="btn btn-outline-primary-600">
            <i class="ri-check-double-line me-1"></i> Mark All as Read
        </button>
    </form>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
    <div class="card-body p-0">
        @if($notifications->count())
            <div class="notification-list">
                @foreach($notifications as $notification)
                    @php
                        $isRead = $notification->reads()->where('user_id', $user->id)->exists();
                        $iconClass = 'ri-notification-3-line';
                        $iconBg = 'bg-primary-600';
                        if ($notification->type == 'fee') {
                            $iconClass = 'ri-money-rupee-circle-line';
                            $iconBg = 'bg-success-600';
                        } elseif ($notification->type == 'exam') {
                            $iconClass = 'ri-file-list-3-line';
                            $iconBg = 'bg-warning-600';
                        } elseif ($notification->type == 'leave') {
                            $iconClass = 'ri-calendar-check-line';
                            $iconBg = 'bg-info-600';
                        } elseif ($notification->type == 'announcement') {
                            $iconClass = 'ri-megaphone-line';
                            $iconBg = 'bg-purple-600';
                        } elseif ($notification->type == 'homework') {
                            $iconClass = 'ri-book-open-line';
                            $iconBg = 'bg-cyan-600';
                        }
                    @endphp
                    <div class="d-flex align-items-start gap-16 px-24 py-16 border-bottom {{ $isRead ? 'bg-white' : 'bg-primary-50' }}">
                        <div class="w-48-px h-48-px {{ $iconBg }} rounded-circle d-flex justify-content-center align-items-center flex-shrink-0">
                            <i class="{{ $iconClass }} text-white text-xl"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center justify-content-between mb-1">
                                <h6 class="fw-semibold text-md text-primary-light mb-0">
                                    {{ $notification->title }}
                                    @if(!$isRead)
                                        <span class="badge bg-primary-600 ms-2" style="font-size: 10px;">NEW</span>
                                    @endif
                                </h6>
                                <div class="d-flex align-items-center gap-2">
                                    @if(!$isRead)
                                        <a href="{{ route('parent.notifications.read', $notification->id) }}" 
                                           class="btn btn-sm btn-outline-success px-8 py-4" 
                                           title="Mark as Read">
                                            <i class="ri-check-line"></i>
                                        </a>
                                    @endif
                                    <form action="{{ route('parent.notifications.destroy', $notification->id) }}" 
                                          method="POST" 
                                          class="d-inline"
                                          onsubmit="return confirm('Delete this notification?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger px-8 py-4" title="Delete">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                            <p class="mb-2 text-secondary-light">{{ $notification->message }}</p>
                            <div class="d-flex align-items-center gap-12">
                                <span class="text-xs text-neutral-500">
                                    <i class="ri-time-line me-1"></i>{{ $notification->created_at->diffForHumans() }}
                                </span>
                                <span class="badge bg-neutral-100 text-neutral-600 text-xs">{{ ucfirst($notification->type) }}</span>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="px-24 py-16">
                {{ $notifications->links() }}
            </div>
        @else
            <div class="text-center py-60">
                <i class="ri-notification-off-line text-6xl text-neutral-300"></i>
                <p class="mb-0 text-secondary-light mt-16 text-lg">No notifications yet</p>
            </div>
        @endif
    </div>
</div>
@endsection
