@extends('layouts.parent')

@section('title', 'Timetable')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Children Timetable</h1>
        <div>
            <a href="{{ route('parent.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Timetable</span>
        </div>
    </div>
</div>

<div class="card mb-24">
    <div class="card-body p-16">
        <div class="row g-12 align-items-center">
            <div class="col-md-4 col-sm-6">
                <label for="childrenSelect" class="form-label mb-4">Select Children</label>
                @if($students->isEmpty())
                    <p class="text-secondary-light mb-0">No children are linked to this parent account.</p>
                @else
                    <form method="GET" action="{{ route('parent.timetable') }}" class="d-flex gap-8">
                        <select id="childrenSelect"
                                name="student_ids[]"
                                class="form-select form-select-sm"
                                {{ $students->count() > 1 ? 'multiple size=3' : '' }}>
                            @foreach($students as $student)
                                <option value="{{ $student->id }}"
                                    {{ in_array($student->id, $selectedIds ?? []) ? 'selected' : '' }}>
                                    {{ $student->name }}
                                    @if($student->schoolClass || $student->section)
                                        - {{ $student->schoolClass->name ?? '' }} {{ $student->section->name ?? '' }}
                                    @endif
                                </option>
                            @endforeach
                        </select>
                        <button type="submit" class="btn btn-primary btn-sm align-self-end">
                            Show
                        </button>
                    </form>
                    <small class="text-secondary-light d-block mt-4">
                        Hold Ctrl (Windows) or Command (Mac) to select more than one child.
                    </small>
                @endif
            </div>
        </div>
    </div>
</div>

@foreach($timetablesByStudent as $studentId => $data)
    @php
        /** @var \App\Models\Student $stu */
        $stu = $data['student'];
        $slots = $data['slots'];
        $overrides = $data['overrides'];
    @endphp

    <div class="card mb-24">
        <div class="card-body p-20">
            <h6 class="mb-16">
                Timetable for {{ $stu->name }}
                @if($stu->schoolClass || $stu->section)
                    <span class="text-secondary-light">
                        ({{ $stu->schoolClass->name ?? '' }} {{ $stu->section->name ?? '' }})
                    </span>
                @endif
            </h6>

            <div class="table-responsive mb-20">
                <table class="table table-striped align-middle">
                    <thead>
                    <tr>
                        <th>Day</th>
                        <th>Time</th>
                        <th>Subject</th>
                        <th>Teacher</th>
                        <th>Room</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($slots as $slot)
                        <tr>
                            <td class="text-capitalize">{{ $slot->day_of_week }}</td>
                            <td>
                                {{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }}
                                -
                                {{ \Carbon\Carbon::parse($slot->end_time)->format('h:i A') }}
                            </td>
                            <td>{{ $slot->subject->name ?? '-' }}</td>
                            <td>{{ $slot->teacher->name ?? '-' }}</td>
                            <td>{{ $slot->room ?? '-' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center text-secondary-light">
                                No weekly timetable slots defined for this class/section.
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            <h6 class="mb-12">Special Day-wise Changes (Overrides)</h6>
            <p class="text-secondary-light text-sm mb-12">
                These are emergency or one-day changes applied by the school. They replace the normal period for that date and time only.
            </p>

            <div class="table-responsive">
                <table class="table table-bordered align-middle">
                    <thead>
                    <tr>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Subject</th>
                        <th>Teacher</th>
                        <th>Room</th>
                        <th>Note</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($overrides as $ov)
                        <tr>
                            <td>{{ $ov->date->format('d M Y') }}</td>
                            <td>
                                {{ \Carbon\Carbon::parse($ov->start_time)->format('h:i A') }}
                                -
                                {{ \Carbon\Carbon::parse($ov->end_time)->format('h:i A') }}
                            </td>
                            <td>{{ $ov->subject->name ?? '-' }}</td>
                            <td>{{ $ov->teacher->name ?? '-' }}</td>
                            <td>{{ $ov->room ?? '-' }}</td>
                            <td>{{ $ov->notes ?? '-' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-secondary-light">
                                No special changes scheduled for this class/section.
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endforeach
@endsection


