<aside class="sidebar">
  <button type="button" class="sidebar-close-btn">
    <iconify-icon icon="radix-icons:cross-2"></iconify-icon>
  </button>
  <div class="">
    <div class="sidebar-logo d-flex align-items-center justify-content-between">
      @php
        $settings = \App\Models\Setting::first();
        $logo = $settings && $settings->logo ? asset('storage/'.$settings->logo) : asset('assets/images/logo.png');
        $logoLight = $settings && $settings->logo_light ? asset('storage/'.$settings->logo_light) : asset('assets/images/logo-light.png');
        $logoIcon = $settings && $settings->logo_icon ? asset('storage/'.$settings->logo_icon) : asset('assets/images/logo-icon.png');
      @endphp
      <a href="{{ route('admin.dashboard') }}" class="">
        <img src="{{ $logo }}" alt="site logo" class="light-logo">
        <img src="{{ $logoLight }}" alt="site logo" class="dark-logo">
        <img src="{{ $logoIcon }}" alt="site logo" class="logo-icon">
      </a>
    </div>
  </div>
  <!-- User Info start -->
  <div class="mx-16 py-12">
    <div class="dropdown profile-dropdown">
      <button type="button"
        class="profile-dropdown__button d-flex align-items-center justify-content-between p-10 w-100 overflow-hidden bg-neutral-50 radius-12 "
        data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
        <span class="d-flex align-items-start gap-10">
          @if($user->photo && \Illuminate\Support\Facades\Storage::disk('public')->exists($user->photo))
            <img src="{{ asset('storage/' . $user->photo) }}" alt="{{ $user->name }}"
              class="w-40-px h-40-px rounded-circle object-fit-cover flex-shrink-0">
          @else
            <span class="w-40-px h-40-px rounded-circle bg-primary-600 d-flex align-items-center justify-content-center flex-shrink-0">
              <span class="text-white fw-bold">{{ strtoupper(substr($user->name, 0, 1)) }}</span>
            </span>
          @endif
          <span class="profile-dropdown__contents">
            <span class="h6 mb-0 text-md d-block text-primary-light">{{ $user->name }}</span>
            <span class="text-secondary-light text-sm mb-0 d-block">{{ ucfirst($user->role) }}</span>
          </span>
        </span>
        <span class="profile-dropdown__icon pe-8 text-xl d-flex line-height-1">
          <i class="ri-arrow-right-s-line"></i>
        </span>
      </button>
      <ul class="dropdown-menu dropdown-menu-lg-end border p-12">
        <li>
          <a href="{{ route('admin.profile.index') }}" 
            class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6">
            <i class="ri-user-3-line"></i>
            My Profile
          </a>
        </li>
        <li>
          <a href="{{ route('admin.settings.branding.edit') }}"
            class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6">
            <i class="ri-settings-3-line"></i>
            Setting
          </a>
        </li>
        <li>
          <form action="{{ route('logout') }}" method="POST">
            @csrf
            <button type="submit"
              class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6 w-100 text-start border-0 bg-transparent">
              <i class="ri-shut-down-line"></i>
              Log Out
            </button>
          </form>
        </li>
      </ul>
    </div>
  </div>
  <!-- User Info end -->
  <div class="sidebar-menu-area">
    <ul class="sidebar-menu" id="sidebar-menu">
      <!-- Dashboard -->
      <li>
        <a href="{{ route('admin.dashboard') }}">
          <i class="ri-home-4-line"></i>
          <span>Dashboard</span>
        </a>
      </li>

      <!-- Academic Setup -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-calendar-2-line"></i>
          <span>Academic</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.academic-year.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Academic Year
            </a>
          </li>
          <li>
            <a href="{{ route('admin.class.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Class
            </a>
          </li>
          <li>
            <a href="{{ route('admin.section.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Section
            </a>
          </li>
          <li>
            <a href="{{ route('admin.batch.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Batch
            </a>
          </li>
          <li>
            <a href="{{ route('admin.subject.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Subjects
            </a>
          </li>
          <li>
            <a href="{{ route('admin.room.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Rooms
            </a>
          </li>
        </ul>
      </li>

      <!-- Students -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-graduation-cap-line"></i>
          <span>Students</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.student.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Student List
            </a>
          </li>
          <li>
            <a href="{{ route('admin.student.create') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Add New Student
            </a>
          </li>
          <li>
            <a href="{{ route('admin.attendance.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Attendance
            </a>
          </li>
        </ul>
      </li>

      <!-- Teachers -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-user-follow-line"></i>
          <span>Teachers</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.teacher.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Teacher List
            </a>
          </li>
          <li>
            <a href="{{ route('admin.teacher.create') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Add New Teacher
            </a>
          </li>
        </ul>
      </li>

      <!-- Parents -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-account-circle-line"></i>
          <span>Parents</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.parent.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Parent List
            </a>
          </li>
          <li>
            <a href="{{ route('admin.parent.create') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Add New Parent
            </a>
          </li>
        </ul>
      </li>

      <!-- Timetable -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-time-line"></i>
          <span>Timetable</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.timetable.create') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Add Timetable
            </a>
          </li>
          <li>
            <a href="{{ route('admin.timetable-override.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Calendar
            </a>
          </li>
        </ul>
      </li>

      <!-- Examinations -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-file-list-3-line"></i>
          <span>Examinations</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.exam-types.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Exam Types
            </a>
          </li>
          <li>
            <a href="{{ route('admin.exam-schedules.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Exam Schedule
            </a>
          </li>
          <li>
            <a href="{{ route('admin.exam-results.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Results
            </a>
          </li>
        </ul>
      </li>

      <!-- Fees Collection -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-money-dollar-circle-line"></i>
          <span>Fees Collection</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.fees-collection.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Fees Collect
            </a>
          </li>
          <li>
            <a href="{{ route('admin.fees-type.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Fees Type
            </a>
          </li>
          <li>
            <a href="{{ route('admin.fees-group.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Fees Group
            </a>
          </li>
          <li>
            <a href="{{ route('admin.fees-assignment.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Assign Fees
            </a>
          </li>
          <li>
            <a href="{{ route('admin.fees-discount.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Fees Discount
            </a>
          </li>
        </ul>
      </li>

      <!-- Leaves -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-logout-circle-line"></i>
          <span>Leaves</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.leave-types.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Leave Types
            </a>
          </li>
          <li>
            <a href="{{ route('admin.leave-requests.index') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Leave Requests
            </a>
          </li>
        </ul>
      </li>

      <!-- Assignment/Homework -->
      <li>
        <a href="{{ route('admin.homework.index') }}">
          <i class="ri-book-open-line"></i>
          <span>Assignment</span>
        </a>
      </li>

      <!-- Note Board -->
      <li>
        <a href="{{ route('admin.notes.index') }}">
          <i class="ri-sticky-note-line"></i>
          <span>Note Board</span>
        </a>
      </li>

      <!-- Notifications -->
      <li>
        <a href="{{ route('admin.notifications.index') }}">
          <i class="ri-notification-3-line"></i>
          <span>Notifications</span>
        </a>
      </li>

      <!-- Settings -->
      <li class="dropdown">
        <a href="javascript:void(0)">
          <i class="ri-settings-3-line"></i>
          <span>Settings</span>
        </a>
        <ul class="sidebar-submenu">
          <li>
            <a href="{{ route('admin.settings.branding.edit') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Branding
            </a>
          </li>
          <li>
            <a href="{{ route('admin.settings.gateways.edit') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Payment Gateways
            </a>
          </li>
          <li>
            <a href="{{ route('admin.settings.notifications.edit') }}">
              <i class="ri-circle-fill circle-icon w-auto"></i>
              Push Notifications
            </a>
          </li>
        </ul>
      </li>
    </ul>
  </div>
</aside>

