@php
    $currentUser = Auth::user();
    $childIds = $currentUser->students->pluck('id')->toArray();
    $classIds = $currentUser->students->pluck('class_id')->filter()->unique()->toArray();
    
    // Get notifications for this parent
    $parentNotifications = \App\Models\Notification::where('is_active', true)
        ->where(function($q) use ($currentUser, $childIds, $classIds) {
            $q->where('for_all_parents', true)
              ->orWhere('parent_id', $currentUser->id)
              ->orWhereIn('student_id', $childIds)
              ->orWhereIn('class_id', $classIds);
        })
        ->whereDoesntHave('reads', function($q) use ($currentUser) {
            $q->where('user_id', $currentUser->id)->whereNotNull('deleted_at');
        })
        ->orderByDesc('created_at')
        ->limit(10)
        ->get();
    
    // Count unread
    $unreadCount = $parentNotifications->filter(function($n) use ($currentUser) {
        return !$n->reads()->where('user_id', $currentUser->id)->exists();
    })->count();
@endphp
<div class="navbar-header shadow-1">
  <div class="row align-items-center justify-content-between">
    <div class="col-auto">
      <div class="d-flex flex-wrap align-items-center gap-4">
        <button type="button" class="sidebar-mobile-toggle" aria-label="Sidebar Mobile Toggler Button">
          <iconify-icon icon="heroicons:bars-3-solid" class="icon"></iconify-icon>
        </button>
        <span class="fw-semibold text-primary-light">Parent Portal</span>
      </div>
    </div>
    <div class="col-auto">
      <div class="d-flex flex-wrap align-items-center gap-3">
        
        <!-- Notification Bell Dropdown -->
        <div class="dropdown">
          <button class="w-40-px h-40-px bg-neutral-200 rounded-circle d-flex justify-content-center align-items-center position-relative border-0" 
                  type="button" 
                  id="parentNotificationDropdown" 
                  data-bs-toggle="dropdown" 
                  aria-expanded="false"
                  aria-label="Notifications">
            <i class="ri-notification-3-line text-xl text-primary-light"></i>
            @if($unreadCount > 0)
              <span class="position-absolute d-flex justify-content-center align-items-center bg-danger text-white rounded-circle" style="font-size: 10px; width: 18px; height: 18px; top: -2px; right: -2px;">
                {{ $unreadCount > 9 ? '9+' : $unreadCount }}
              </span>
            @endif
          </button>
          <div class="dropdown-menu dropdown-menu-end p-0 shadow-lg border-0" aria-labelledby="parentNotificationDropdown" style="min-width: 360px; max-height: 450px; overflow-y: auto;">
            <div class="d-flex align-items-center justify-content-between px-16 py-12 border-bottom bg-neutral-50">
              <h6 class="mb-0 fw-semibold text-md">Notifications</h6>
              <div class="d-flex align-items-center gap-2">
                @if($unreadCount > 0)
                  <form action="{{ route('parent.notifications.mark-all-read') }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-link btn-sm p-0 text-primary-600 text-decoration-none" style="font-size: 12px;">
                      <i class="ri-check-double-line"></i> Read All
                    </button>
                  </form>
                @endif
              </div>
            </div>
            
            @if($parentNotifications->count())
              <div class="notification-list" style="max-height: 320px; overflow-y: auto;">
                @foreach($parentNotifications as $notification)
                  @php
                    $isRead = $notification->reads()->where('user_id', $currentUser->id)->exists();
                    $iconClass = 'ri-notification-3-line';
                    $iconBg = 'bg-primary-600';
                    if ($notification->type == 'fee') {
                        $iconClass = 'ri-money-rupee-circle-line';
                        $iconBg = 'bg-success-600';
                    } elseif ($notification->type == 'exam') {
                        $iconClass = 'ri-file-list-3-line';
                        $iconBg = 'bg-warning-600';
                    } elseif ($notification->type == 'leave') {
                        $iconClass = 'ri-calendar-check-line';
                        $iconBg = 'bg-info-600';
                    } elseif ($notification->type == 'announcement') {
                        $iconClass = 'ri-megaphone-line';
                        $iconBg = 'bg-purple-600';
                    }
                  @endphp
                  <a href="{{ route('parent.notifications.read', $notification->id) }}" 
                     class="d-flex align-items-start gap-12 px-16 py-12 border-bottom text-decoration-none {{ $isRead ? 'bg-white' : 'bg-primary-50' }}"
                     style="transition: background 0.2s;">
                    <div class="w-40-px h-40-px {{ $iconBg }} rounded-circle d-flex justify-content-center align-items-center flex-shrink-0">
                      <i class="{{ $iconClass }} text-white"></i>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center justify-content-between">
                        <h6 class="fw-semibold text-sm text-primary-light mb-1">{{ $notification->title }}</h6>
                        @if(!$isRead)
                          <span class="w-8-px h-8-px bg-primary-600 rounded-circle flex-shrink-0"></span>
                        @endif
                      </div>
                      <p class="mb-1 text-secondary-light text-xs">{{ \Illuminate\Support\Str::limit($notification->message, 60) }}</p>
                      <span class="text-xs text-neutral-500">{{ $notification->created_at->diffForHumans() }}</span>
                    </div>
                  </a>
                @endforeach
              </div>
              <a href="{{ route('parent.notifications.index') }}" class="d-block text-center py-12 border-top text-primary-600 fw-semibold text-sm text-decoration-none">
                <i class="ri-arrow-right-line me-1"></i> View All Notifications
              </a>
            @else
              <div class="text-center py-40">
                <i class="ri-notification-off-line text-4xl text-neutral-300"></i>
                <p class="mb-0 text-secondary-light mt-8 text-sm">No notifications yet</p>
              </div>
              <a href="{{ route('parent.notifications.index') }}" class="d-block text-center py-12 border-top text-primary-600 fw-semibold text-sm text-decoration-none">
                <i class="ri-arrow-right-line me-1"></i> View All Notifications
              </a>
            @endif
          </div>
        </div>

        <!-- Logout -->
        <form action="{{ route('logout') }}" method="POST" class="m-0">
          @csrf
          <button type="submit" class="btn btn-outline-danger btn-sm d-flex align-items-center gap-1">
            <i class="ri-logout-box-r-line"></i>
            <span>Logout</span>
          </button>
        </form>
      </div>
    </div>
  </div>
</div>
