@php
    $currentUser = Auth::user();
    
    // Get notifications for this teacher
    $teacherNotifications = \App\Models\TeacherNotification::where('teacher_id', $currentUser->id)
        ->orderByDesc('created_at')
        ->limit(10)
        ->get();
    
    // Count unread
    $unreadCount = \App\Models\TeacherNotification::where('teacher_id', $currentUser->id)
        ->whereNull('read_at')
        ->count();
@endphp
<div class="navbar-header shadow-1">
  <div class="row align-items-center justify-content-between">
    <div class="col-auto">
      <div class="d-flex flex-wrap align-items-center gap-4">
        <button type="button" class="sidebar-mobile-toggle" aria-label="Sidebar Mobile Toggler Button">
          <iconify-icon icon="heroicons:bars-3-solid" class="icon"></iconify-icon>
        </button>
        <span class="fw-semibold text-primary-light">Teacher Portal</span>
      </div>
    </div>
    <div class="col-auto">
      <div class="d-flex flex-wrap align-items-center gap-3">
        
        <!-- Notification Bell Dropdown -->
        <div class="dropdown">
          <button class="w-40-px h-40-px bg-neutral-200 rounded-circle d-flex justify-content-center align-items-center position-relative border-0" 
                  type="button" 
                  id="teacherNotificationDropdown" 
                  data-bs-toggle="dropdown" 
                  aria-expanded="false"
                  aria-label="Notifications">
            <i class="ri-notification-3-line text-xl text-primary-light"></i>
            @if($unreadCount > 0)
              <span class="position-absolute d-flex justify-content-center align-items-center bg-danger text-white rounded-circle" style="font-size: 10px; width: 18px; height: 18px; top: -2px; right: -2px;">
                {{ $unreadCount > 9 ? '9+' : $unreadCount }}
              </span>
            @endif
          </button>
          <div class="dropdown-menu dropdown-menu-end p-0 shadow-lg border-0" aria-labelledby="teacherNotificationDropdown" style="min-width: 360px; max-height: 450px;">
            <div class="d-flex align-items-center justify-content-between px-16 py-12 border-bottom bg-neutral-50">
              <h6 class="mb-0 fw-semibold text-md">Notifications</h6>
              <div class="d-flex align-items-center gap-2">
                @if($unreadCount > 0)
                  <form action="{{ route('teacher.notifications.mark-all-read') }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-link btn-sm p-0 text-primary-600 text-decoration-none" style="font-size: 12px;">
                      <i class="ri-check-double-line"></i> Read All
                    </button>
                  </form>
                @endif
              </div>
            </div>
            
            @if($teacherNotifications->count())
              <div class="notification-list" style="max-height: 320px; overflow-y: auto;">
                @foreach($teacherNotifications as $notification)
                  <a href="{{ route('teacher.notifications.read', $notification->id) }}" 
                     class="d-flex align-items-start gap-12 px-16 py-12 border-bottom text-decoration-none {{ $notification->read_at ? 'bg-white' : 'bg-primary-50' }}">
                    <div class="w-40-px h-40-px {{ $notification->icon_bg ?? 'bg-primary-600' }} rounded-circle d-flex justify-content-center align-items-center flex-shrink-0">
                      <i class="{{ $notification->icon ?? 'ri-notification-3-line' }} text-white"></i>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center justify-content-between">
                        <h6 class="fw-semibold text-sm text-primary-light mb-1">{{ $notification->title }}</h6>
                        @if(!$notification->read_at)
                          <span class="w-8-px h-8-px bg-primary-600 rounded-circle flex-shrink-0"></span>
                        @endif
                      </div>
                      <p class="mb-1 text-secondary-light text-xs">{{ \Illuminate\Support\Str::limit($notification->message, 60) }}</p>
                      <span class="text-xs text-neutral-500">{{ $notification->created_at->diffForHumans() }}</span>
                    </div>
                  </a>
                @endforeach
              </div>
              <div class="text-center py-12 border-top bg-white">
                <a href="{{ route('teacher.notifications.index') }}" class="text-primary-600 fw-semibold text-sm text-decoration-none">
                  <i class="ri-arrow-right-line me-1"></i> View All Notifications
                </a>
              </div>
            @else
              <div class="text-center py-40">
                <i class="ri-notification-off-line text-4xl text-neutral-300"></i>
                <p class="mb-0 text-secondary-light mt-8 text-sm">No notifications yet</p>
              </div>
            @endif
          </div>
        </div>

        <!-- Logout -->
        <form action="{{ route('logout') }}" method="POST" class="m-0">
          @csrf
          <button type="submit" class="btn btn-outline-danger btn-sm d-flex align-items-center gap-1">
            <i class="ri-logout-box-r-line"></i>
            <span>Logout</span>
          </button>
        </form>
      </div>
    </div>
  </div>
</div>
