@extends('layouts.teacher')

@section('title', 'Teacher Dashboard')

@section('content')
<div class="row gy-3">
    <div class="col-xl-4 col-lg-5">
        <div class="shadow-1 radius-12 bg-base h-100 p-20 d-flex flex-column">
            <div class="d-flex align-items-center gap-12 mb-16">
                @php
                    $photoPath = isset($teacher) && $teacher && $teacher->photo ? asset('storage/'.$teacher->photo) : asset('assets/images/thumbs/leave-request-img2.png');
                @endphp
                <img src="{{ $photoPath }}" alt="Photo" class="rounded-circle object-fit-cover" style="width:64px;height:64px;">
                <div>
                    <h5 class="fw-semibold text-primary-light mb-4">{{ $teacher->name ?? $user->name }}</h5>
                    <p class="mb-0 text-secondary-light text-sm">Teacher</p>
                </div>
            </div>
            <div class="border rounded-3 p-12 mb-16">
                <p class="mb-1 text-sm text-secondary-light"><span class="fw-semibold text-neutral-800">Email:</span> {{ $teacher->email ?? $user->email }}</p>
                <p class="mb-1 text-sm text-secondary-light"><span class="fw-semibold text-neutral-800">Phone:</span> {{ $teacher->phone ?? '-' }}</p>
                <p class="mb-0 text-sm text-secondary-light"><span class="fw-semibold text-neutral-800">Subjects:</span>
                    @if($teacher?->subjects && $teacher->subjects->count())
                        {{ $teacher->subjects->pluck('name')->join(', ') }}
                    @else
                        -
                    @endif
                </p>
            </div>
            <div class="d-flex flex-column gap-8">
                <a href="{{ route('teacher.profile.edit') }}" class="btn btn-primary-600 w-100">Manage Profile</a>
                <a href="{{ route('teacher.attendance.index') }}" class="btn btn-outline-primary w-100">Mark Attendance</a>
                <a href="{{ route('teacher.leave-requests.index') }}" class="btn btn-outline-primary w-100">Leave Requests</a>
            </div>
        </div>
    </div>

    <div class="col-xl-8 col-lg-7">
        <div class="row gy-3">
            <div class="col-md-4">
                <div class="shadow-1 radius-12 bg-base p-16 h-100">
                    <p class="text-secondary-light text-sm mb-4">Subjects</p>
                    <h3 class="h4 fw-semibold mb-2">{{ $subjectCount ?? 0 }}</h3>
                    <p class="mb-0 text-secondary-light text-sm">Assigned to you</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="shadow-1 radius-12 bg-base p-16 h-100">
                    <p class="text-secondary-light text-sm mb-4">Today's Classes</p>
                    <h3 class="h4 fw-semibold mb-2">{{ $todayClassCount ?? 0 }}</h3>
                    <p class="mb-0 text-secondary-light text-sm">Including overrides</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="shadow-1 radius-12 bg-base p-16 h-100">
                    <p class="text-secondary-light text-sm mb-4">Pending Leaves</p>
                    <h3 class="h4 fw-semibold mb-2 text-warning">{{ $pendingLeaves ?? 0 }}</h3>
                    <p class="mb-0 text-secondary-light text-sm">Awaiting approval</p>
                </div>
            </div>
        </div>

        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden mt-3">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Today's Schedule</h6>
            </div>
            <div class="card-body p-20">
                @php
                    $slot = $currentSlot ?? $nextSlot ?? null;
                @endphp
                @if($slot)
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <div>
                            <p class="mb-1 text-secondary-light text-sm">
                                {{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }} - {{ \Carbon\Carbon::parse($slot->end_time)->format('h:i A') }}
                            </p>
                            <h6 class="fw-semibold mb-1 text-primary-light">{{ $slot->subject->name ?? 'Subject' }}</h6>
                            <p class="mb-0 text-secondary-light text-sm">
                                {{ $slot->schoolClass->name ?? '' }} @if($slot->section)/ {{ $slot->section->name }}@endif
                            </p>
                        </div>
                        @if($currentSlot && $slot === $currentSlot)
                            <span class="badge bg-success-subtle text-success">Ongoing</span>
                        @elseif($nextSlot && $slot === $nextSlot)
                            <span class="badge bg-primary-subtle text-primary">Next</span>
                        @endif
                    </div>
                @else
                    <p class="mb-0 text-secondary-light">No more classes scheduled for today.</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection



