@extends('layouts.teacher')

@section('content')
<div class="page-header">
    <div class="row align-items-center">
        <div class="col">
            <h3 class="page-title">Exam Schedules</h3>
        </div>
        <div class="col-auto">
            <a href="{{ route('teacher.exams.schedules.create') }}" class="btn btn-primary">
                <i class="ri-add-line"></i> Add Exam Schedule
            </a>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" class="row g-3 mb-3">
            <div class="col-md-4">
                <label class="form-label">Exam Type</label>
                <select name="exam_type_id" class="form-select">
                    <option value="">All</option>
                    @foreach($examTypes as $examType)
                        <option value="{{ $examType->id }}" {{ ($filters['exam_type_id'] ?? '') == $examType->id ? 'selected' : '' }}>
                            {{ $examType->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Class</label>
                <select name="class_id" class="form-select">
                    <option value="">All</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ ($filters['class_id'] ?? '') == $class->id ? 'selected' : '' }}>
                            {{ $class->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Section</label>
                <select name="section_id" class="form-select">
                    <option value="">All</option>
                    @foreach($sections as $section)
                        <option value="{{ $section->id }}" {{ ($filters['section_id'] ?? '') == $section->id ? 'selected' : '' }}>
                            {{ $section->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100 me-2">Filter</button>
                <a href="{{ route('teacher.exams.schedules.index') }}" class="btn btn-outline-secondary w-100">Clear</a>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-striped mb-0">
                <thead>
                    <tr>
                        <th>Exam Type</th>
                        <th>Class</th>
                        <th>Section</th>
                        <th>Subject</th>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Room</th>
                        <th>Max Marks</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($schedules as $schedule)
                        <tr>
                            <td>{{ $schedule->examType->name ?? '-' }}</td>
                            <td>{{ $schedule->schoolClass->name ?? '-' }}</td>
                            <td>{{ $schedule->section->name ?? '-' }}</td>
                            <td>{{ $schedule->subject->name ?? '-' }}</td>
                            <td>{{ \Carbon\Carbon::parse($schedule->exam_date)->format('d M Y') }}</td>
                            <td>
                                {{ \Carbon\Carbon::parse($schedule->start_time)->format('h:i A') }}
                                -
                                {{ \Carbon\Carbon::parse($schedule->end_time)->format('h:i A') }}
                            </td>
                            <td>{{ $schedule->room->name ?? '-' }}</td>
                            <td>{{ $schedule->max_marks ?? '-' }}</td>
                            <td>
                                <a href="{{ route('teacher.exams.schedules.marks', $schedule) }}" class="btn btn-sm btn-outline-primary">
                                    Enter Marks
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center">No exam schedules found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection


