@extends('layouts.teacher')

@section('content')
<div class="page-header">
    <div class="row align-items-center">
        <div class="col">
            <h3 class="page-title">Enter Marks</h3>
            <p class="text-muted mb-0">
                {{ $examSchedule->examType->name ?? '' }} -
                {{ $examSchedule->schoolClass->name ?? '' }} {{ $examSchedule->section->name ?? '' }} -
                {{ $examSchedule->subject->name ?? '' }} |
                {{ \Carbon\Carbon::parse($examSchedule->exam_date)->format('d M Y') }}
                ({{ \Carbon\Carbon::parse($examSchedule->start_time)->format('h:i A') }} -
                {{ \Carbon\Carbon::parse($examSchedule->end_time)->format('h:i A') }})
            </p>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form action="{{ route('teacher.exams.schedules.marks.store', $examSchedule) }}" method="POST">
            @csrf
            <div class="table-responsive">
                <table class="table table-striped mb-0">
                    <thead>
                        <tr>
                            <th>Student</th>
                            <th>Roll No</th>
                            <th>Marks @if($examSchedule->max_marks) ( / {{ $examSchedule->max_marks }}) @endif</th>
                            <th>Absent</th>
                            <th>Grade</th>
                            <th>Remark</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($students as $student)
                            @php
                                $result = $results->get($student->id);
                            @endphp
                            <tr>
                                <td>{{ $student->name }}</td>
                                <td>{{ $student->roll_number ?? '-' }}</td>
                                <td style="max-width: 120px;">
                                    <input type="number"
                                           name="marks[{{ $student->id }}]"
                                           class="form-control form-control-sm"
                                           value="{{ old('marks.' . $student->id, $result->marks_obtained ?? '') }}"
                                           min="0"
                                           @if($examSchedule->max_marks) max="{{ $examSchedule->max_marks }}" @endif>
                                </td>
                                <td class="text-center">
                                    <input type="checkbox"
                                           name="absent[{{ $student->id }}]"
                                           value="1"
                                           {{ old('absent.' . $student->id, $result->is_absent ?? false) ? 'checked' : '' }}>
                                </td>
                                <td>{{ $result->grade ?? '-' }}</td>
                                <td>
                                    <input type="text"
                                           name="remark[{{ $student->id }}]"
                                           class="form-control form-control-sm"
                                           value="{{ old('remark.' . $student->id, $result->remark ?? '') }}">
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No students found for this class and section.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="text-end mt-3">
                <button type="submit" class="btn btn-primary">Save Marks</button>
            </div>
        </form>
    </div>
</div>
@endsection


