@extends('layouts.teacher')

@section('title', 'My Profile')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">My Profile</h1>
        <span class="text-secondary-light">Update your details</span>
    </div>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

@if($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('teacher.profile.update') }}" method="POST" enctype="multipart/form-data" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-4">
            <div class="shadow-1 radius-12 bg-base h-100 p-20 text-center">
                @php
                    $photoPath = $teacher->photo ? asset('storage/'.$teacher->photo) : asset('assets/images/thumbs/leave-request-img2.png');
                @endphp
                <img src="{{ $photoPath }}" alt="Photo" class="rounded-circle object-fit-cover mb-12" style="width:120px;height:120px;">
                <div class="mb-2 text-secondary-light text-sm">{{ $user->email }}</div>
                <input type="file" name="photo" class="form-control" accept="image/*">
                <small class="text-secondary-light d-block mt-1">PNG/JPG up to 2MB.</small>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Profile Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Full Name <span class="text-danger-600">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $teacher->name) }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Email</label>
                            <input type="email" name="email" class="form-control" value="{{ old('email', $teacher->email ?? $user->email) }}">
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Phone</label>
                            <input type="text" name="phone" class="form-control" value="{{ old('phone', $teacher->phone) }}">
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Gender</label>
                            <select name="gender" class="form-select">
                                @php $genderVal = old('gender', $teacher->gender); @endphp
                                <option value="">Select</option>
                                <option value="Male" {{ $genderVal === 'Male' ? 'selected' : '' }}>Male</option>
                                <option value="Female" {{ $genderVal === 'Female' ? 'selected' : '' }}>Female</option>
                                <option value="Other" {{ $genderVal === 'Other' ? 'selected' : '' }}>Other</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Date of Birth</label>
                            <input type="date" name="date_of_birth" class="form-control" value="{{ old('date_of_birth', $teacher->date_of_birth ? $teacher->date_of_birth->format('Y-m-d') : '') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Qualification</label>
                            <input type="text" name="qualification" class="form-control" value="{{ old('qualification', $teacher->qualification) }}">
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Experience</label>
                            <input type="text" name="experience" class="form-control" value="{{ old('experience', $teacher->experience) }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Changes
                </button>
            </div>
        </div>
    </div>
</form>
@endsection


