@extends('layouts.teacher')

@section('title', 'My Timetable')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-4 h6 text-primary-light">My Timetable</h1>
        <div>
            <a href="{{ route('teacher.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ My Timetable</span>
        </div>
    </div>
</div>

<div class="row g-24">
    <div class="col-12">
        <div class="card h-100">
            <div class="card-body p-20">
                <h6 class="mb-16">Weekly Timetable</h6>
                <div class="table-responsive">
                    <table class="table table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Day</th>
                                <th>Time</th>
                                <th>Class &amp; Section</th>
                                <th>Subject</th>
                                <th>Room</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($slots as $slot)
                                <tr>
                                    <td class="text-capitalize">{{ $slot->day_of_week }}</td>
                                    <td>
                                        {{ \Carbon\Carbon::parse($slot->start_time)->format('h:i A') }}
                                        -
                                        {{ \Carbon\Carbon::parse($slot->end_time)->format('h:i A') }}
                                    </td>
                                    <td>
                                        {{ $slot->schoolClass->name ?? '-' }}
                                        {{ $slot->section->name ?? '' }}
                                    </td>
                                    <td>{{ $slot->subject->name ?? '-' }}</td>
                                    <td>{{ $slot->room ?? '-' }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-secondary-light">
                                        No timetable slots assigned yet.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 mt-24">
        <div class="card h-100">
            <div class="card-body p-20">
                <h6 class="mb-16">Upcoming Day-wise Changes (Overrides)</h6>
                <p class="text-secondary-light text-sm mb-12">
                    These are special changes made by admin for specific dates. They override the regular weekly timetable only for that day.
                </p>
                <div class="table-responsive">
                    <table class="table table-bordered align-middle">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Class &amp; Section</th>
                                <th>Subject</th>
                                <th>Room</th>
                                <th>Note</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($overrides as $ov)
                                <tr>
                                    <td>{{ $ov->date->format('d M Y') }}</td>
                                    <td>
                                        {{ \Carbon\Carbon::parse($ov->start_time)->format('h:i A') }}
                                        -
                                        {{ \Carbon\Carbon::parse($ov->end_time)->format('h:i A') }}
                                    </td>
                                    <td>
                                        {{ $ov->schoolClass->name ?? '-' }}
                                        {{ $ov->section->name ?? '' }}
                                    </td>
                                    <td>{{ $ov->subject->name ?? '-' }}</td>
                                    <td>{{ $ov->room ?? '-' }}</td>
                                    <td>{{ $ov->notes ?? '-' }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center text-secondary-light">
                                        No special changes scheduled.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



